/*
 * Decompiled with CFR 0.152.
 */
package cc.mtz.sts.zza;

import cc.mtz.sts.zza.Main;
import cc.mtz.sts.zza.StellwerkFile;
import cc.mtz.sts.zza.data.Bahnhof;
import cc.mtz.sts.zza.data.DataCache;
import cc.mtz.sts.zza.data.ZugBelegung;
import cc.mtz.sts.zza.listener.StsListener;
import cc.mtz.sts.zza.sound.SoundPlayer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import js.java.stspluginlib.PluginClient;

public class PluginClientImpl
extends PluginClient {
    private final StellwerkFile config;
    private final List<StsListener> listener;
    private boolean ready = true;
    private DataCache currentCache;
    private DataCache lastRunCache;
    private Set<Integer> zuegeZuVerarbeiten;
    private Map<String, Set<String>> einfahrtGemeldet = new HashMap<String, Set<String>>();
    private Map<String, Set<String>> abfahrtGemeldet = new HashMap<String, Set<String>>();
    private Map<String, Set<String>> haltGemeldet = new HashMap<String, Set<String>>();
    private Map<Integer, String> einfahrtsGleise = new HashMap<Integer, String>();

    public PluginClientImpl(String name, String author, String version, String text, StellwerkFile config, List<StsListener> listener) {
        super(name, author, version, text);
        this.config = config;
        this.listener = listener;
        this.currentCache = new DataCache();
        SoundPlayer.getInstance().addReplaces(config.getSoundReplaces());
    }

    public DataCache getLastRunCache() {
        return new DataCache(this.lastRunCache);
    }

    protected void connected() {
        this.request_bahnsteigliste();
    }

    protected void closed() {
        System.exit(0);
    }

    protected void response_anlageninfo(int aid, String name, String build) {
    }

    protected void response_bahnsteigliste(HashMap<String, HashSet<String>> bl) {
        ArrayList<String> keys = new ArrayList<String>(bl.keySet());
        Collections.sort(keys);
        for (int bhf = 0; bhf < this.config.getBahnhoefe().size(); ++bhf) {
            for (String bahnsteig : keys) {
                if (!Pattern.matches(this.config.getBahnhoefe().get(bhf).getGleiseRegex(), bahnsteig)) continue;
                for (StsListener callback : this.listener) {
                    callback.bahnsteigSetup(bahnsteig, this.config.getBahnhoefe().get(bhf));
                }
            }
        }
        if (this.ready) {
            this.ready = false;
            this.currentCache.clear();
            this.request_zugliste();
        }
    }

    protected void response_zugliste(HashMap<Integer, String> zl) {
        this.zuegeZuVerarbeiten = new HashSet<Integer>(zl.keySet());
        for (int zid : zl.keySet()) {
            this.request_zugdetails(zid);
        }
    }

    protected void response_zugdetails(int zid, PluginClient.ZugDetails details) {
        this.currentCache.getDetailCache().put(zid, details);
        this.request_zugfahrplan(zid);
        this.register_ereignis(zid, "ankunft");
        this.register_ereignis(zid, "abfahrt");
    }

    protected void response_zugfahrplan(int zid, LinkedList<PluginClient.ZugFahrplanZeile> plan) {
        try {
            this.currentCache.getFahrplaene().put(zid, plan);
            this.zuegeZuVerarbeiten.remove(zid);
            for (PluginClient.ZugFahrplanZeile zeile : plan) {
                for (Bahnhof bahnhof : this.config.getBahnhoefe()) {
                    if (!Pattern.matches(bahnhof.getGleiseRegex(), zeile.gleis)) continue;
                    List<ZugBelegung> gleisBelegung = this.currentCache.getBelegung().get(zeile.gleis);
                    if (gleisBelegung == null) {
                        gleisBelegung = new ArrayList<ZugBelegung>();
                    }
                    gleisBelegung.add(new ZugBelegung(this.currentCache.getDetailCache().get(zid), zeile));
                    this.currentCache.getBelegung().put(zeile.gleis, gleisBelegung);
                }
            }
            if (this.zuegeZuVerarbeiten.isEmpty()) {
                this.lastRunCache = new DataCache(this.currentCache);
                boolean soundIdle = SoundPlayer.getInstance().isIdle();
                long simutime = this.getSimutime();
                for (String gleis : this.currentCache.getBelegung().keySet()) {
                    List<ZugBelegung> gleisBelegung = this.currentCache.getBelegung().get(gleis);
                    boolean zugVorhanden = false;
                    if (gleisBelegung != null) {
                        Collections.sort(gleisBelegung, new ZugBelegung.DelayComparator());
                        for (ZugBelegung zugBelegung : gleisBelegung) {
                            if (zugBelegung.zeile == null || zugBelegung.zug == null || zugBelegung.zeile.an + (long)(zugBelegung.zug.verspaetung * 60000) <= simutime && zugBelegung.zeile.ab + (long)(zugBelegung.zug.verspaetung * 60000) <= simutime) continue;
                            zugVorhanden = true;
                            this.naechsterZug(zugBelegung.zug.zid, zugBelegung.zeile.gleis);
                            break;
                        }
                    }
                    if (zugVorhanden) continue;
                    for (StsListener callback : this.listener) {
                        callback.keinZug(gleis);
                    }
                }
                if (soundIdle) {
                    for (StsListener callback : this.listener) {
                        callback.idleAction(this.currentCache);
                    }
                }
                this.ready = true;
            }
        }
        catch (Exception ex) {
            Logger.getLogger(Main.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    protected void response_ereignis(int zid, String art, PluginClient.ZugDetails zugDetails) {
        block6: {
            Bahnhof bahnhof;
            block5: {
                Bahnhof bahnhof2;
                this.currentCache.getDetailCache().put(zid, zugDetails);
                if (!art.equals("ankunft")) break block5;
                if (!this.currentCache.getDetailCache().get((Object)Integer.valueOf((int)zid)).sichtbar || !this.currentCache.getDetailCache().get((Object)Integer.valueOf((int)zid)).amgleis || !this.isTrainStopping(zid, this.currentCache.getDetailCache().get((Object)Integer.valueOf((int)zid)).gleis) || (bahnhof2 = this.getBahnhofByGleis(this.currentCache.getDetailCache().get((Object)Integer.valueOf((int)zid)).gleis)) == null || this.haltGemeldet.containsKey(this.currentCache.getDetailCache().get((Object)Integer.valueOf((int)zid)).gleis) && this.haltGemeldet.get(this.currentCache.getDetailCache().get((Object)Integer.valueOf((int)zid)).gleis).contains(this.currentCache.getDetailCache().get((Object)Integer.valueOf((int)zid)).name)) break block6;
                this.einfahrtsGleise.put(zid, this.currentCache.getDetailCache().get((Object)Integer.valueOf((int)zid)).gleis);
                for (StsListener callback : this.listener) {
                    if (!this.haltGemeldet.containsKey(this.currentCache.getDetailCache().get((Object)Integer.valueOf((int)zid)).gleis)) {
                        this.haltGemeldet.put(this.currentCache.getDetailCache().get((Object)Integer.valueOf((int)zid)).gleis, new HashSet());
                    }
                    this.haltGemeldet.get(this.currentCache.getDetailCache().get((Object)Integer.valueOf((int)zid)).gleis).add(this.currentCache.getDetailCache().get((Object)Integer.valueOf((int)zid)).name);
                    callback.zugHalt(this.currentCache.getDetailCache().get((Object)Integer.valueOf((int)zid)).gleis, bahnhof2, zid, this.currentCache);
                }
                break block6;
            }
            if (!(!art.equals("abfahrt") || this.einfahrtsGleise.get(zid) == null || (bahnhof = this.getBahnhofByGleis(this.einfahrtsGleise.get(zid))) == null || this.abfahrtGemeldet.containsKey(this.einfahrtsGleise.get(zid)) && this.abfahrtGemeldet.get(this.einfahrtsGleise.get(zid)).contains(this.currentCache.getDetailCache().get((Object)Integer.valueOf((int)zid)).name))) {
                for (StsListener callback : this.listener) {
                    if (!this.abfahrtGemeldet.containsKey(this.einfahrtsGleise.get(zid))) {
                        this.abfahrtGemeldet.put(this.einfahrtsGleise.get(zid), new HashSet());
                    }
                    this.abfahrtGemeldet.get(this.einfahrtsGleise.get(zid)).add(this.currentCache.getDetailCache().get((Object)Integer.valueOf((int)zid)).name);
                    callback.zugAbfahrt(this.einfahrtsGleise.get(zid), bahnhof, zid, this.currentCache);
                }
            }
        }
    }

    public void naechsterZug(int zid, String gleis) {
        if (this.currentCache.getDetailCache().get(zid) == null) {
            return;
        }
        Bahnhof bahnhof = null;
        for (Bahnhof bhf : this.config.getBahnhoefe()) {
            if (!Pattern.matches(bhf.getGleiseRegex(), gleis)) continue;
            bahnhof = bhf;
            break;
        }
        if (bahnhof == null) {
            return;
        }
        for (StsListener callback : this.listener) {
            callback.naechsterZug(gleis, bahnhof, zid, this.currentCache);
        }
        if (this.currentCache.getDetailCache().get((Object)Integer.valueOf((int)zid)).sichtbar && this.currentCache.getDetailCache().get((Object)Integer.valueOf((int)zid)).gleis.equals(gleis) && (!this.einfahrtGemeldet.containsKey(gleis) || !this.einfahrtGemeldet.get(gleis).contains(this.currentCache.getDetailCache().get((Object)Integer.valueOf((int)zid)).name))) {
            for (StsListener callback : this.listener) {
                if (!this.einfahrtGemeldet.containsKey(gleis)) {
                    this.einfahrtGemeldet.put(gleis, new HashSet());
                }
                this.einfahrtGemeldet.get(gleis).add(this.currentCache.getDetailCache().get((Object)Integer.valueOf((int)zid)).name);
                callback.zugEinfahrt(gleis, bahnhof, zid, this.currentCache);
            }
        }
    }

    private Bahnhof getBahnhofByGleis(String gleis) {
        for (Bahnhof bhf : this.config.getBahnhoefe()) {
            if (!Pattern.matches(bhf.getGleiseRegex(), gleis)) continue;
            return bhf;
        }
        return null;
    }

    private boolean isTrainStopping(int zid, String gleis) {
        Iterator<PluginClient.ZugFahrplanZeile> iterator = this.currentCache.getFahrplaene().get(zid).iterator();
        if (iterator.hasNext()) {
            PluginClient.ZugFahrplanZeile zeile = iterator.next();
            return zeile.gleis.equals(gleis) && !zeile.flags.hasFlag('D');
        }
        return false;
    }

    public void haltGemeldet(int zid, String gleis) {
        if (this.haltGemeldet.containsKey(gleis)) {
            this.haltGemeldet.get(gleis).add(this.currentCache.getDetailCache().get((Object)Integer.valueOf((int)zid)).name);
        }
    }

    public void requestZuege() {
        this.ready = false;
        this.currentCache.clear();
        this.request_zugliste();
    }

    public boolean isReady() {
        return this.ready;
    }
}

