/*
 * Decompiled with CFR 0.152.
 */
package marytts.language.de.preprocess;

import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import marytts.language.de.preprocess.ExpansionPattern;
import marytts.language.de.preprocess.REPattern;
import marytts.util.dom.MaryDomUtils;
import org.w3c.dom.DOMException;
import org.w3c.dom.Element;

public class CompositeEP
extends ExpansionPattern {
    Pattern reTrailingHyphen = Pattern.compile("([A-Z\u00c4\u00d6\u00dca-z\u00e4\u00f6\u00fc\u00df])-$");
    Pattern reLeadingHyphen = Pattern.compile("^-([A-Z\u00c4\u00d6\u00dca-z\u00e4\u00f6\u00fc\u00df])");
    Pattern reLettersDigitsAndHyphens = Pattern.compile("([^-]*[A-Z\u00c4\u00d6\u00dca-z\u00e4\u00f6\u00fc\u00df0-9][^-]*)(-[^-]*[A-Z\u00c4\u00d6\u00dca-z\u00e4\u00f6\u00fc\u00df0-9][^-]*)+");
    Pattern reLettersAndDigits = Pattern.compile("(?:(?:[A-Z\u00c4\u00d6\u00dca-z\u00e4\u00f6\u00fc\u00df]+[0-9]+)|(?:[0-9]+[A-Z\u00c4\u00d6\u00dca-z\u00e4\u00f6\u00fc\u00df]+))[A-Z\u00c4\u00d6\u00dca-z\u00e4\u00f6\u00fc\u00df0-9]*");
    private final Pattern reMatchingChars = Pattern.compile("");

    @Override
    public List<String> knownTypes() {
        return new ArrayList<String>();
    }

    @Override
    public Pattern reMatchingChars() {
        return this.reMatchingChars;
    }

    private List<Element> process(List<Element> tokens) {
        ArrayList<Element> result = new ArrayList<Element>();
        for (Element t : tokens) {
            if (!t.getTagName().equals("t")) {
                throw new DOMException(15, "Expected t element");
            }
            ArrayList<Element> expanded = new ArrayList<Element>();
            this.process(t, expanded);
            if (expanded.isEmpty()) {
                result.add(t);
                continue;
            }
            result.addAll(expanded);
        }
        return result;
    }

    @Override
    public boolean process(Element t, List<Element> expanded) {
        StringTokenizer st;
        if (t == null || expanded == null) {
            throw new NullPointerException("Received null argument");
        }
        if (!t.getTagName().equals("t")) {
            throw new DOMException(15, "Expected t element");
        }
        if (!expanded.isEmpty()) {
            throw new IllegalArgumentException("Expected empty list, but list has " + expanded.size() + " elements.");
        }
        if (t.hasAttribute("ph") || t.hasAttribute("sounds_like")) {
            return false;
        }
        String s = MaryDomUtils.tokenText((Element)t);
        if (this.reTrailingHyphen.matcher(s).find()) {
            s = this.reTrailingHyphen.matcher(s).replaceFirst("$1");
            MaryDomUtils.setTokenText((Element)t, (String)s);
        }
        if (this.reLeadingHyphen.matcher(s).find()) {
            s = this.reLeadingHyphen.matcher(s).replaceFirst("$1");
            MaryDomUtils.setTokenText((Element)t, (String)s);
        }
        if (this.reLettersDigitsAndHyphens.matcher(s).matches()) {
            MaryDomUtils.encloseWithMTU((Element)t, (String)s, (String)"first");
            st = new StringTokenizer(s, "-");
            assert (st.hasMoreTokens());
            MaryDomUtils.setTokenText((Element)t, (String)st.nextToken());
            expanded.add(t);
            while (st.hasMoreTokens()) {
                t = MaryDomUtils.appendToken((Element)t, (String)st.nextToken());
                expanded.add(t);
            }
        } else if (this.reLettersAndDigits.matcher(s).matches()) {
            MaryDomUtils.encloseWithMTU((Element)t, (String)s, (String)"first");
            String s1 = s;
            boolean isFirst = true;
            while (s1.length() > 0) {
                String part;
                Matcher reMatcher = REPattern.initialNonDigits.matcher(s1);
                if (reMatcher.find()) {
                    part = reMatcher.group();
                    s1 = reMatcher.replaceFirst("");
                } else {
                    reMatcher = REPattern.initialDigits.matcher(s1);
                    reMatcher.find();
                    part = reMatcher.group();
                    s1 = reMatcher.replaceFirst("");
                }
                if (isFirst) {
                    MaryDomUtils.setTokenText((Element)t, (String)part);
                } else {
                    t = MaryDomUtils.appendToken((Element)t, (String)part);
                }
                expanded.add(t);
                isFirst = false;
            }
        } else if (s.equals("'s")) {
            t.setAttribute("ph", "s");
            expanded.add(t);
        } else if (s.endsWith("'s")) {
            t.setAttribute("sounds_like", s.substring(0, s.length() - 2));
            t.setAttribute("ph", "*s");
            expanded.add(t);
        } else if (ExpansionPattern.reSplitAtChars().matcher(s).find() && (REPattern.letter.matcher(s).find() || REPattern.digit.matcher(s).find())) {
            MaryDomUtils.encloseWithMTU((Element)t, (String)s, (String)"last");
            st = new StringTokenizer(s, ExpansionPattern.getSplitAtChars(), true);
            MaryDomUtils.setTokenText((Element)t, (String)st.nextToken());
            expanded.add(t);
            while (st.hasMoreTokens()) {
                t = MaryDomUtils.appendToken((Element)t, (String)st.nextToken());
                expanded.add(t);
            }
        }
        if (expanded.size() > 0) {
            List<Element> newExpanded = this.process(expanded);
            expanded.clear();
            expanded.addAll(newExpanded);
        }
        return false;
    }

    @Override
    protected int canDealWith(String input, int typeCode) {
        return this.match(input, typeCode);
    }

    @Override
    protected int match(String input, int typeCode) {
        throw new RuntimeException("This method should not be called.");
    }

    @Override
    protected List<Element> expand(List<Element> tokens, String text, int typeCode) {
        throw new RuntimeException("This method should not be called.");
    }
}

