/*
 * Decompiled with CFR 0.152.
 */
package marytts.language.de;

import java.util.List;
import java.util.Locale;
import marytts.datatypes.MaryData;
import marytts.language.de.postlex.PhonologicalRules;
import marytts.modules.PronunciationModel;
import marytts.util.dom.MaryDomUtils;
import marytts.util.dom.NameNodeFilter;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.traversal.DocumentTraversal;
import org.w3c.dom.traversal.NodeFilter;
import org.w3c.dom.traversal.TreeWalker;

public class Postlex
extends PronunciationModel {
    public Postlex() {
        super(Locale.GERMAN);
    }

    public MaryData process(MaryData d) throws Exception {
        Document doc = d.getDocument();
        this.mtuPostlex(doc);
        this.phonologicalRules(doc);
        return super.process(d);
    }

    private void mtuPostlex(Document doc) throws DOMException {
        TreeWalker tw = ((DocumentTraversal)((Object)doc)).createTreeWalker(doc, 1, (NodeFilter)new NameNodeFilter(new String[]{"mtu"}), false);
        Element m = null;
        while ((m = (Element)tw.nextNode()) != null) {
            if (MaryDomUtils.hasAncestor((Node)m, (String)"mtu")) continue;
            Element c = m;
            while (c != null && !c.getTagName().equals("t")) {
                String whatToAccent = c.getAttribute("accent");
                if (whatToAccent != null && whatToAccent.equals("first")) {
                    c = MaryDomUtils.getFirstChildElement((Element)c);
                    continue;
                }
                c = MaryDomUtils.getLastChildElement((Element)c);
            }
            Element retainAccentToken = c;
            NodeList tokens = m.getElementsByTagName("t");
            for (int i = 0; i < tokens.getLength(); ++i) {
                Element t = (Element)tokens.item(i);
                if (t == retainAccentToken) continue;
                t.removeAttribute("accent");
            }
        }
    }

    private void phonologicalRules(Document doc) {
        NodeList allTokens = doc.getElementsByTagName("t");
        for (int i = 0; i < allTokens.getLength(); ++i) {
            String phonolPrecisionString;
            Element t = (Element)allTokens.item(i);
            if (!t.hasAttribute("ph")) continue;
            String transcript = t.getAttribute("ph");
            int phonolPrecision = 2;
            Element phonolAncestor = (Element)MaryDomUtils.getAncestor((Node)t, (String)"phonology");
            if (phonolAncestor != null && (phonolPrecisionString = phonolAncestor.getAttribute("precision")) != null) {
                if (phonolPrecisionString.equals("precise")) {
                    phonolPrecision = 1;
                } else if (phonolPrecisionString.equals("sloppy")) {
                    phonolPrecision = 3;
                }
            }
            boolean hasAccent = t.hasAttribute("accent") && !t.getAttribute("accent").equals("none");
            int precision = phonolPrecision;
            if (hasAccent) {
                if (precision == 2) {
                    precision = 1;
                } else if (precision == 3) {
                    precision = 2;
                }
            }
            List rules = PhonologicalRules.getRules();
            for (PhonologicalRules pr : rules) {
                if (!pr.matches(transcript)) continue;
                transcript = pr.apply(transcript, precision);
            }
            t.setAttribute("ph", transcript);
        }
    }
}

