/*
 * Decompiled with CFR 0.152.
 */
package marytts.signalproc.sinusoidal;

import java.io.File;
import java.io.IOException;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.UnsupportedAudioFileException;
import marytts.signalproc.analysis.PitchMarks;
import marytts.signalproc.analysis.PitchReaderWriter;
import marytts.signalproc.filter.ComplementaryFilterBankAnalyser;
import marytts.signalproc.filter.FIRBandPassFilterBankAnalyser;
import marytts.signalproc.filter.FIRWaveletFilterBankAnalyser;
import marytts.signalproc.filter.FilterBankAnalyserBase;
import marytts.signalproc.filter.Subband;
import marytts.signalproc.sinusoidal.BaseSinusoidalAnalyzer;
import marytts.signalproc.sinusoidal.PitchSynchronousSinusoidalAnalyzer;
import marytts.signalproc.sinusoidal.SinusoidalAnalysisParams;
import marytts.signalproc.sinusoidal.SinusoidalAnalyzer;
import marytts.signalproc.sinusoidal.SinusoidalTracks;
import marytts.util.data.audio.AudioDoubleDataSource;
import marytts.util.math.MathUtils;
import marytts.util.signal.SignalProcUtils;

public class MultiresolutionSinusoidalAnalyzer
extends BaseSinusoidalAnalyzer {
    public FilterBankAnalyserBase filterbankAnalyser;
    public int multiresolutionFilterbankType;
    public int numBands;
    public int samplingRate;

    public MultiresolutionSinusoidalAnalyzer(int multiresolutionFilterbankTypeIn, int numBandsIn, int samplingRateIn) {
        this.multiresolutionFilterbankType = multiresolutionFilterbankTypeIn;
        this.numBands = numBandsIn;
        this.samplingRate = samplingRateIn;
        this.filterbankAnalyser = null;
        if (this.multiresolutionFilterbankType == 1) {
            double overlapAround1000Hz = 100.0;
            this.filterbankAnalyser = new FIRBandPassFilterBankAnalyser(this.numBands, this.samplingRate, overlapAround1000Hz);
        } else if (this.multiresolutionFilterbankType == 2) {
            double overlapAround1000Hz = 100.0;
            this.filterbankAnalyser = new FIRWaveletFilterBankAnalyser(this.numBands, this.samplingRate);
        } else if (this.multiresolutionFilterbankType == 3) {
            if (!MathUtils.isPowerOfTwo(this.numBands)) {
                int tmpNumBands;
                for (tmpNumBands = 2; tmpNumBands < this.numBands; tmpNumBands *= 2) {
                }
                this.numBands = tmpNumBands;
                System.out.println("Number of bands should be a power of two for the complementary filterbank");
            }
            int baseFilterOrder = SignalProcUtils.getFIRFilterOrder(this.samplingRate);
            int numLevels = this.numBands - 1;
            this.filterbankAnalyser = new ComplementaryFilterBankAnalyser(numLevels, baseFilterOrder);
        }
    }

    public SinusoidalTracks[] analyze(double[] x, double lowestBandWindowSizeInSeconds, int windowType, boolean bRefinePeakEstimatesParabola, boolean bRefinePeakEstimatesBias, boolean bSpectralReassignment, boolean bAdjustNeighFreqDependent, boolean bFreqLimitedAnalysis) {
        return this.analyze(x, lowestBandWindowSizeInSeconds, windowType, bRefinePeakEstimatesParabola, bRefinePeakEstimatesBias, bSpectralReassignment, bAdjustNeighFreqDependent, bFreqLimitedAnalysis, false, null, 0.0f);
    }

    public SinusoidalTracks[] analyze(double[] x, double lowestBandWindowSizeInSeconds, int windowType, boolean bRefinePeakEstimatesParabola, boolean bRefinePeakEstimatesBias, boolean bSpectralReassignment, boolean bAdjustNeighFreqDependent, boolean bFreqLimitedAnalysis, boolean bPitchSynchronousAnalysis, PitchMarks pm, float numPeriods) {
        SinusoidalTracks[] subbandTracks = new SinusoidalTracks[this.numBands];
        Subband[] subbands = null;
        if (this.multiresolutionFilterbankType != 1) {
            bFreqLimitedAnalysis = false;
        }
        if (this.filterbankAnalyser != null) {
            subbands = this.filterbankAnalyser.apply(x);
            SinusoidalAnalysisParams params = null;
            for (int i = 0; i < subbands.length; ++i) {
                float deltaInHz;
                float skipSizeInSeconds;
                float winSizeInSeconds;
                SinusoidalAnalyzer sa;
                if (!bPitchSynchronousAnalysis || i > 0) {
                    sa = null;
                    if (bFreqLimitedAnalysis) {
                        params = new SinusoidalAnalysisParams((int)subbands[i].samplingRate, subbands[i].lowestFreqInHz, subbands[i].highestFreqInHz, windowType, bRefinePeakEstimatesParabola, bRefinePeakEstimatesBias, bSpectralReassignment, bAdjustNeighFreqDependent);
                        sa = new SinusoidalAnalyzer(params);
                    } else {
                        params = new SinusoidalAnalysisParams((int)subbands[i].samplingRate, 0.0, 0.5 * subbands[i].samplingRate, windowType, bRefinePeakEstimatesParabola, bRefinePeakEstimatesBias, bSpectralReassignment, bAdjustNeighFreqDependent);
                        sa = new SinusoidalAnalyzer(params);
                    }
                    winSizeInSeconds = (float)(lowestBandWindowSizeInSeconds / Math.pow(2.0, i));
                    skipSizeInSeconds = 0.5f * winSizeInSeconds;
                    deltaInHz = 50.0f;
                    subbandTracks[i] = this.multiresolutionFilterbankType == 2 ? sa.analyzeFixedRate(subbands[i].waveform, winSizeInSeconds, skipSizeInSeconds, deltaInHz, 0) : sa.analyzeFixedRate(x, winSizeInSeconds, skipSizeInSeconds, deltaInHz, 0);
                    if (this.multiresolutionFilterbankType != 1) continue;
                    this.normalizeSinusoidalAmplitudes(subbandTracks[i], this.samplingRate, ((FIRBandPassFilterBankAnalyser)this.filterbankAnalyser).normalizationFilterTransformedIR);
                    continue;
                }
                sa = null;
                if (bFreqLimitedAnalysis) {
                    params = new SinusoidalAnalysisParams((int)subbands[i].samplingRate, subbands[i].lowestFreqInHz, subbands[i].highestFreqInHz, windowType, bRefinePeakEstimatesParabola, bRefinePeakEstimatesBias, bSpectralReassignment, bAdjustNeighFreqDependent);
                    sa = new PitchSynchronousSinusoidalAnalyzer(params);
                } else {
                    params = new SinusoidalAnalysisParams((int)subbands[i].samplingRate, 0.0, 0.5 * subbands[i].samplingRate, windowType, bRefinePeakEstimatesParabola, bRefinePeakEstimatesBias, bSpectralReassignment, bAdjustNeighFreqDependent);
                    sa = new PitchSynchronousSinusoidalAnalyzer(params);
                }
                winSizeInSeconds = (float)(lowestBandWindowSizeInSeconds / Math.pow(2.0, i));
                skipSizeInSeconds = 0.5f * winSizeInSeconds;
                deltaInHz = 50.0f;
                float numPeriodsCurrent = (float)((double)numPeriods / Math.pow(2.0, i));
                subbandTracks[i] = ((PitchSynchronousSinusoidalAnalyzer)sa).analyzePitchSynchronous(x, pm, numPeriodsCurrent, skipSizeInSeconds, deltaInHz, 0);
            }
        }
        return subbandTracks;
    }

    public void normalizeSinusoidalAmplitudes(SinusoidalTracks sinTracks, int samplingRateIn, double[] normalizationFilterTransformedIR) {
        int maxFreq = normalizationFilterTransformedIR.length - 1;
        for (int i = 0; i < sinTracks.tracks.length; ++i) {
            int j = 0;
            while (j < sinTracks.tracks[i].totalSins) {
                int k = SignalProcUtils.freq2index(SignalProcUtils.radian2hz(sinTracks.tracks[i].freqs[j], sinTracks.fs), (double)samplingRateIn, maxFreq);
                int n = j++;
                sinTracks.tracks[i].amps[n] = (float)((double)sinTracks.tracks[i].amps[n] * normalizationFilterTransformedIR[k]);
            }
        }
    }

    public static void main(String[] args) throws UnsupportedAudioFileException, IOException {
        AudioInputStream inputAudio = AudioSystem.getAudioInputStream(new File(args[0]));
        int samplingRate = (int)inputAudio.getFormat().getSampleRate();
        AudioDoubleDataSource signal = new AudioDoubleDataSource(inputAudio);
        double[] x = signal.getAllData();
        int multiresolutionFilterbankType = 2;
        int numBands = 4;
        double lowestBandWindowSizeInSeconds = 0.02;
        double startFreqInHz = 0.0;
        double endFreqInHz = 0.5 * (double)samplingRate;
        int windowType = 1;
        boolean bRefinePeakEstimatesParabola = true;
        boolean bRefinePeakEstimatesBias = true;
        boolean bSpectralReassignment = true;
        boolean bAdjustNeighFreqDependent = true;
        boolean bFreqLimitedAnalysis = false;
        boolean bPitchSynchronous = false;
        float numPeriods = 2.5f;
        SinusoidalAnalysisParams params = new SinusoidalAnalysisParams(samplingRate, startFreqInHz, endFreqInHz, windowType, bRefinePeakEstimatesParabola, bRefinePeakEstimatesBias, bSpectralReassignment, bAdjustNeighFreqDependent);
        MultiresolutionSinusoidalAnalyzer msa = new MultiresolutionSinusoidalAnalyzer(multiresolutionFilterbankType, numBands, samplingRate);
        SinusoidalTracks[] subbandTracks = null;
        if (!bPitchSynchronous) {
            subbandTracks = msa.analyze(x, lowestBandWindowSizeInSeconds, windowType, bRefinePeakEstimatesParabola, bRefinePeakEstimatesBias, bSpectralReassignment, bAdjustNeighFreqDependent, bFreqLimitedAnalysis);
        } else {
            String strPitchFile = args[0].substring(0, args[0].length() - 4) + ".ptc";
            PitchReaderWriter f0 = new PitchReaderWriter(strPitchFile);
            int pitchMarkOffset = 0;
            PitchMarks pm = SignalProcUtils.pitchContour2pitchMarks(f0.contour, samplingRate, x.length, f0.header.windowSizeInSeconds, f0.header.skipSizeInSeconds, true, pitchMarkOffset);
            PitchSynchronousSinusoidalAnalyzer sa = new PitchSynchronousSinusoidalAnalyzer(params);
            subbandTracks = msa.analyze(x, lowestBandWindowSizeInSeconds, windowType, bRefinePeakEstimatesParabola, bRefinePeakEstimatesBias, bSpectralReassignment, bAdjustNeighFreqDependent, bFreqLimitedAnalysis, true, pm, numPeriods);
        }
    }
}

