/*
 * Decompiled with CFR 0.152.
 */
package marytts.signalproc.analysis;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import marytts.util.io.FileUtils;
import marytts.util.string.StringUtils;

public class PraatScriptGenerator {
    public static void main(String[] args) throws IOException {
        String wavFolder = args[0];
        String[] wavFiles = FileUtils.getFileList(wavFolder, "wav", true);
        if (wavFiles != null) {
            String outputFile;
            int i;
            String scriptFile = args[1];
            FileOutputStream fos = new FileOutputStream(scriptFile);
            OutputStreamWriter out = new OutputStreamWriter((OutputStream)fos, "UTF-8");
            for (i = 0; i < wavFiles.length; ++i) {
                out.write("Read from file... " + wavFiles[i] + System.getProperty("line.separator"));
                out.write("To Harmonicity (cc)... 0.01 75 0.1 1.0" + System.getProperty("line.separator"));
                outputFile = StringUtils.modifyExtension(wavFiles[i], "hcc");
                out.write("Write to text file... " + outputFile + System.getProperty("line.separator"));
                out.write("select all" + System.getProperty("line.separator"));
                out.write("Remove" + System.getProperty("line.separator"));
                out.write("Read from file... " + wavFiles[i] + System.getProperty("line.separator"));
                out.write("To Harmonicity (ac)... 0.01 75 0.1 4.5" + System.getProperty("line.separator"));
                outputFile = StringUtils.modifyExtension(wavFiles[i], "hac");
                out.write("Write to text file... " + outputFile + System.getProperty("line.separator"));
                out.write("select all" + System.getProperty("line.separator"));
                out.write("Remove" + System.getProperty("line.separator"));
                out.write("Read from file... " + wavFiles[i] + System.getProperty("line.separator"));
                out.write("To Harmonicity (gne)... 500 4500 1000 80" + System.getProperty("line.separator"));
                outputFile = StringUtils.modifyExtension(wavFiles[i], "hgne");
                out.write("Write to text file... " + outputFile + System.getProperty("line.separator"));
                out.write("select all" + System.getProperty("line.separator"));
                out.write("Remove" + System.getProperty("line.separator"));
                System.out.println("Added harmonicity file " + String.valueOf(i + 1) + " of " + String.valueOf(wavFiles.length));
            }
            out.close();
            scriptFile = args[2];
            fos = new FileOutputStream(scriptFile);
            out = new OutputStreamWriter((OutputStream)fos, "UTF-8");
            for (i = 0; i < wavFiles.length; ++i) {
                out.write("Read from file... " + wavFiles[i] + System.getProperty("line.separator"));
                out.write("snd = selected (\"Sound\")" + System.getProperty("line.separator"));
                out.write("To Pitch (cc)... 0 60 15 yes 0.03 0.45 0.01 0.35 0.14 600" + System.getProperty("line.separator"));
                out.write("pit = selected (\"Pitch\")" + System.getProperty("line.separator"));
                out.write("select snd" + System.getProperty("line.separator"));
                out.write("plus pit" + System.getProperty("line.separator"));
                out.write("To PointProcess (cc)" + System.getProperty("line.separator"));
                out.write("# Jitter" + System.getProperty("line.separator"));
                out.write("jitter_local = Get jitter (local)... 0 0 0.0001 0.02 1.3" + System.getProperty("line.separator"));
                out.write("jitter_local_abs = Get jitter (local, absolute)... 0 0 0.0001 0.02 1.3" + System.getProperty("line.separator"));
                out.write("rap = Get jitter (rap)... 0 0 0.0001 0.02 1.3" + System.getProperty("line.separator"));
                out.write("ppq = Get jitter (ppq5)... 0 0 0.0001 0.02 1.3" + System.getProperty("line.separator"));
                out.write("ddp = Get jitter (ddp)... 0 0 0.0001 0.02 1.3" + System.getProperty("line.separator"));
                out.write("# write values to file" + System.getProperty("line.separator"));
                outputFile = StringUtils.modifyExtension(wavFiles[i], "jit" + System.getProperty("line.separator"));
                out.write("fileappend \"jitterOut.txt\" 'fn$''tab$''jitter_local''tab$''jitter_local_abs''tab$''rap''tab$''ppq''tab$''ddp''newline$'" + System.getProperty("line.separator"));
                out.write("# calculation of shimmer" + System.getProperty("line.separator"));
                out.write("plus snd" + System.getProperty("line.separator"));
                out.write("shim_local = Get shimmer (local)... 0 0 0.0001 0.02 1.3 1.6" + System.getProperty("line.separator"));
                out.write("shim_local_db = Get shimmer (local_dB)... 0 0 0.0001 0.02 1.3 1.6" + System.getProperty("line.separator"));
                out.write("apq3 = Get shimmer (apq3)... 0 0 0.0001 0.02 1.3 1.6" + System.getProperty("line.separator"));
                out.write("apq5 = Get shimmer (apq5)... 0 0 0.0001 0.02 1.3 1.6" + System.getProperty("line.separator"));
                out.write("apq11 = Get shimmer (apq11)... 0 0 0.0001 0.02 1.3 1.6" + System.getProperty("line.separator"));
                out.write("dda = Get shimmer (dda)... 0 0 0.0001 0.02 1.3 1.6" + System.getProperty("line.separator"));
                out.write("# write values to file" + System.getProperty("line.separator"));
                outputFile = StringUtils.modifyExtension(wavFiles[i], "shi" + System.getProperty("line.separator"));
                out.write("fileappend \"shimmerOut.txt\" 'fn$''tab$''shim_local''tab$''shim_local_db''tab$''apq3''tab$''apq5''tab$''apq11''tab$''dda''newline$'" + System.getProperty("line.separator"));
                System.out.println("Added jitter/shimmer file " + String.valueOf(i + 1) + " of " + String.valueOf(wavFiles.length));
                out.write("select all" + System.getProperty("line.separator"));
                out.write("Remove" + System.getProperty("line.separator"));
            }
            out.close();
        }
    }
}

