/*
 * Decompiled with CFR 0.152.
 */
package com.sun.speech.freetts;

import com.sun.speech.freetts.PartOfSpeech;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;

public class PartOfSpeechImpl
implements PartOfSpeech {
    private int lineCount = 0;
    private Map partOfSpeechMap = new HashMap();
    private String defaultPartOfSpeech;

    public PartOfSpeechImpl(URL url, String defaultPartOfSpeech) throws IOException {
        this.defaultPartOfSpeech = defaultPartOfSpeech;
        BufferedReader reader = new BufferedReader(new InputStreamReader(url.openStream()));
        String line = reader.readLine();
        ++this.lineCount;
        while (line != null) {
            if (!line.startsWith("***")) {
                this.parseAndAdd(line);
            }
            line = reader.readLine();
        }
        reader.close();
    }

    private void parseAndAdd(String line) {
        StringTokenizer tokenizer = new StringTokenizer(line, " ");
        try {
            String word = tokenizer.nextToken();
            String pos = tokenizer.nextToken();
            this.partOfSpeechMap.put(word, pos);
        }
        catch (NoSuchElementException nse) {
            System.err.println("part of speech data in bad format at line " + this.lineCount);
        }
    }

    public String getPartOfSpeech(String word) {
        String pos = (String)this.partOfSpeechMap.get(word);
        if (pos == null) {
            pos = this.defaultPartOfSpeech;
        }
        return pos;
    }
}

