/*
 * Copyright 2011 Matthias Butz <mtz@mtz.cc>. All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without modification, are
 * permitted provided that the following conditions are met:
 *
 *   1. Redistributions of source code must retain the above copyright notice, this list of
 *      conditions and the following disclaimer.
 *
 *   2. Redistributions in binary form must reproduce the above copyright notice, this list
 *      of conditions and the following disclaimer in the documentation and/or other materials
 *      provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY MATTHIAS BUTZ ''AS IS'' AND ANY EXPRESS OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
 * FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL MATTHIAS BUTZ OR
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON
 * ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF
 * ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

/*
 * BahnsteigSelector.java
 *
 * Created on 01.03.2011, 22:07:54
 */
package cc.mtz.sts.zza.ui;

import cc.mtz.sts.zza.Main;
import cc.mtz.sts.zza.SimpleConfig;
import cc.mtz.sts.zza.StellwerkFile;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JFileChooser;
import javax.xml.parsers.ParserConfigurationException;
import org.xml.sax.SAXException;

/**
 *
 * @author Matze
 */
public class BahnsteigSelector extends javax.swing.JFrame {

    /** Creates new form BahnsteigSelector */
    public BahnsteigSelector() {
        initComponents();
    }

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        buttonGroup1 = new javax.swing.ButtonGroup();
        jScrollPane1 = new javax.swing.JScrollPane();
        lstBahnsteige = new javax.swing.JList();
        btnStart = new javax.swing.JButton();
        radAdvanced = new javax.swing.JRadioButton();
        radSimple = new javax.swing.JRadioButton();
        txtFile = new javax.swing.JTextField();
        btnBrowse = new javax.swing.JButton();
        jLabel1 = new javax.swing.JLabel();
        jLabel2 = new javax.swing.JLabel();
        jPanel1 = new javax.swing.JPanel();
        chkZza = new javax.swing.JCheckBox();
        chkAnsage = new javax.swing.JCheckBox();
        chkAnsageEinfahrt = new javax.swing.JCheckBox();
        chkAnsageAnschluesse = new javax.swing.JCheckBox();
        chkAnsageVerspaetungen = new javax.swing.JCheckBox();
        chkRis = new javax.swing.JCheckBox();
        jLabel3 = new javax.swing.JLabel();
        jLabel4 = new javax.swing.JLabel();
        txtBahnhofsname = new javax.swing.JTextField();
        jLabel5 = new javax.swing.JLabel();
        btnCancel = new javax.swing.JButton();
        jPanel2 = new javax.swing.JPanel();
        txtHost = new javax.swing.JTextField();
        jLabel6 = new javax.swing.JLabel();
        jLabel7 = new javax.swing.JLabel();

        setDefaultCloseOperation(javax.swing.WindowConstants.DISPOSE_ON_CLOSE);
        setTitle("Zugzielanzeiger + Bahnsteigansage für StellwerkSim");

        jScrollPane1.setViewportView(lstBahnsteige);

        btnStart.setText("Start");
        btnStart.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                btnStartActionPerformed(evt);
            }
        });

        buttonGroup1.add(radAdvanced);
        radAdvanced.setSelected(true);
        radAdvanced.setText("Erweiterter Modus");
        radAdvanced.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                radAdvancedActionPerformed(evt);
            }
        });

        buttonGroup1.add(radSimple);
        radSimple.setText("Einfacher Modus");

        txtFile.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                txtFileActionPerformed(evt);
            }
        });

        btnBrowse.setText("Durchsuchen...");
        btnBrowse.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                btnBrowseActionPerformed(evt);
            }
        });

        jLabel1.setText("<html>Auswahl einer Konfigurationsdatei für das aktuelle Stellwerk mit Definition<br/> der Bahnhöfe und optionalen erweiterten Zuglaufdefinitionen im XML-Format");

        jLabel2.setText("<html>Definition eines einzelnen Bahnhofs<br/>durch Auswahl der Bahnsteige in<br/>rechtsseitiger Liste.<br/>(STRG gedrückt halten zur Auswahl<br/>mehrerer Bahnsteige)");

        jPanel1.setBorder(javax.swing.BorderFactory.createTitledBorder("Optionen"));

        chkZza.setSelected(true);
        chkZza.setText("Zugzielanzeiger aktivieren");
        chkZza.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                chkZzaActionPerformed(evt);
            }
        });

        chkAnsage.setSelected(true);
        chkAnsage.setText("Ansagemodul aktivieren");
        chkAnsage.addChangeListener(new javax.swing.event.ChangeListener() {
            public void stateChanged(javax.swing.event.ChangeEvent evt) {
                chkAnsageStateChanged(evt);
            }
        });
        chkAnsage.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                chkAnsageActionPerformed(evt);
            }
        });

        chkAnsageEinfahrt.setSelected(true);
        chkAnsageEinfahrt.setText("Einfahrt ansagen");
        chkAnsageEinfahrt.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                chkAnsageEinfahrtActionPerformed(evt);
            }
        });

        chkAnsageAnschluesse.setSelected(true);
        chkAnsageAnschluesse.setText("Anschlüsse ansagen");

        chkAnsageVerspaetungen.setSelected(true);
        chkAnsageVerspaetungen.setText("Verspätungen ansagen");

        chkRis.setText("Zugläufe aus RIS beziehen");
        chkRis.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                chkRisActionPerformed(evt);
            }
        });

        javax.swing.GroupLayout jPanel1Layout = new javax.swing.GroupLayout(jPanel1);
        jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(
            jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanel1Layout.createSequentialGroup()
                .addContainerGap()
                .addGroup(jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addComponent(chkZza)
                    .addComponent(chkAnsage)
                    .addComponent(chkAnsageEinfahrt)
                    .addComponent(chkAnsageAnschluesse)
                    .addComponent(chkAnsageVerspaetungen)
                    .addComponent(chkRis))
                .addContainerGap(94, Short.MAX_VALUE))
        );
        jPanel1Layout.setVerticalGroup(
            jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanel1Layout.createSequentialGroup()
                .addComponent(chkZza)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(chkAnsage)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(chkAnsageEinfahrt)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(chkAnsageAnschluesse)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(chkAnsageVerspaetungen)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(chkRis)
                .addContainerGap(javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
        );

        jLabel3.setText("Datei:");

        jLabel4.setText("Bahnsteige:");

        jLabel5.setText("Bahnhofsname:");

        btnCancel.setText("Abbrechen");
        btnCancel.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                btnCancelActionPerformed(evt);
            }
        });

        jPanel2.setBorder(javax.swing.BorderFactory.createTitledBorder("Verbindung"));

        txtHost.setText("localhost");

        jLabel6.setText("Stellwerksrechner:");

        jLabel7.setText("<html>(Änderung nur bei Nutzung mehrerer Rechner<br/>notwendig.)");

        javax.swing.GroupLayout jPanel2Layout = new javax.swing.GroupLayout(jPanel2);
        jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(
            jPanel2Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanel2Layout.createSequentialGroup()
                .addContainerGap()
                .addGroup(jPanel2Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addGroup(jPanel2Layout.createSequentialGroup()
                        .addComponent(jLabel6)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(txtHost, javax.swing.GroupLayout.PREFERRED_SIZE, 137, javax.swing.GroupLayout.PREFERRED_SIZE))
                    .addComponent(jLabel7, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addContainerGap(13, Short.MAX_VALUE))
        );
        jPanel2Layout.setVerticalGroup(
            jPanel2Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanel2Layout.createSequentialGroup()
                .addGroup(jPanel2Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(jLabel6)
                    .addComponent(txtHost, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(jLabel7, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addContainerGap(25, Short.MAX_VALUE))
        );

        javax.swing.GroupLayout layout = new javax.swing.GroupLayout(getContentPane());
        getContentPane().setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING, false)
                    .addGroup(layout.createSequentialGroup()
                        .addGap(22, 22, 22)
                        .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                            .addGroup(layout.createSequentialGroup()
                                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                                    .addComponent(radSimple)
                                    .addGroup(layout.createSequentialGroup()
                                        .addGap(21, 21, 21)
                                        .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                                            .addGroup(layout.createSequentialGroup()
                                                .addComponent(jLabel5)
                                                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
                                                .addComponent(txtBahnhofsname, javax.swing.GroupLayout.PREFERRED_SIZE, 106, javax.swing.GroupLayout.PREFERRED_SIZE))
                                            .addComponent(jLabel2, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))))
                                .addGap(31, 31, 31)
                                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                                    .addComponent(jScrollPane1, javax.swing.GroupLayout.PREFERRED_SIZE, 146, javax.swing.GroupLayout.PREFERRED_SIZE)
                                    .addComponent(jLabel4)))
                            .addGroup(layout.createSequentialGroup()
                                .addGap(21, 21, 21)
                                .addComponent(jLabel1, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                            .addComponent(radAdvanced))
                        .addGap(20, 20, 20))
                    .addGroup(javax.swing.GroupLayout.Alignment.TRAILING, layout.createSequentialGroup()
                        .addContainerGap(javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                        .addComponent(jLabel3)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
                        .addComponent(txtFile, javax.swing.GroupLayout.PREFERRED_SIZE, 142, javax.swing.GroupLayout.PREFERRED_SIZE)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(btnBrowse)
                        .addGap(66, 66, 66)))
                .addGap(4, 4, 4)
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addGroup(layout.createSequentialGroup()
                        .addComponent(btnStart, javax.swing.GroupLayout.PREFERRED_SIZE, 130, javax.swing.GroupLayout.PREFERRED_SIZE)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(btnCancel, javax.swing.GroupLayout.DEFAULT_SIZE, 146, Short.MAX_VALUE))
                    .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.TRAILING, false)
                        .addComponent(jPanel2, javax.swing.GroupLayout.Alignment.LEADING, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                        .addComponent(jPanel1, javax.swing.GroupLayout.Alignment.LEADING, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)))
                .addContainerGap())
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addGroup(layout.createSequentialGroup()
                        .addContainerGap()
                        .addComponent(radAdvanced)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
                        .addComponent(jLabel1, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                            .addComponent(txtFile, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                            .addComponent(btnBrowse)
                            .addComponent(jLabel3))
                        .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING, false)
                            .addGroup(layout.createSequentialGroup()
                                .addGap(21, 21, 21)
                                .addComponent(radSimple)
                                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                                .addComponent(jLabel2, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                                    .addComponent(jLabel5)
                                    .addComponent(txtBahnhofsname, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                                .addGap(66, 66, 66))
                            .addGroup(layout.createSequentialGroup()
                                .addGap(39, 39, 39)
                                .addComponent(jLabel4)
                                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                                .addComponent(jScrollPane1, javax.swing.GroupLayout.PREFERRED_SIZE, 178, javax.swing.GroupLayout.PREFERRED_SIZE))))
                    .addGroup(layout.createSequentialGroup()
                        .addGap(19, 19, 19)
                        .addComponent(jPanel1, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(jPanel2, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING, false)
                            .addComponent(btnStart, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                            .addComponent(btnCancel, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))))
                .addContainerGap(21, Short.MAX_VALUE))
        );

        getAccessibleContext().setAccessibleName("Zugzielanzeiger + Bahnsteigansage für StellwerkSim");

        pack();
    }// </editor-fold>//GEN-END:initComponents

private void radAdvancedActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_radAdvancedActionPerformed
// TODO add your handling code here:
}//GEN-LAST:event_radAdvancedActionPerformed
    
private void btnBrowseActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_btnBrowseActionPerformed
    JFileChooser chooser = new JFileChooser();
    if (chooser.showOpenDialog(this) == JFileChooser.APPROVE_OPTION) {
        try {
            txtFile.setText(chooser.getSelectedFile().getCanonicalPath());
        } catch (IOException ex) {
            Logger.getLogger(BahnsteigSelector.class.getName()).log(Level.SEVERE, null, ex);
        }
    }
}//GEN-LAST:event_btnBrowseActionPerformed
    
private void txtFileActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_txtFileActionPerformed
// TODO add your handling code here:
}//GEN-LAST:event_txtFileActionPerformed
    
private void chkZzaActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_chkZzaActionPerformed
// TODO add your handling code here:
}//GEN-LAST:event_chkZzaActionPerformed
    
private void chkAnsageEinfahrtActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_chkAnsageEinfahrtActionPerformed
// TODO add your handling code here:
}//GEN-LAST:event_chkAnsageEinfahrtActionPerformed
    
private void chkRisActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_chkRisActionPerformed
// TODO add your handling code here:
}//GEN-LAST:event_chkRisActionPerformed
    
private void chkAnsageActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_chkAnsageActionPerformed
}//GEN-LAST:event_chkAnsageActionPerformed
    
private void chkAnsageStateChanged(javax.swing.event.ChangeEvent evt) {//GEN-FIRST:event_chkAnsageStateChanged
    if (chkAnsage.isSelected()) {
        chkAnsageAnschluesse.setEnabled(true);
        chkAnsageEinfahrt.setEnabled(true);
        chkAnsageVerspaetungen.setEnabled(true);
    } else {
        chkAnsageAnschluesse.setEnabled(false);
        chkAnsageEinfahrt.setEnabled(false);
        chkAnsageVerspaetungen.setEnabled(false);
    }
}//GEN-LAST:event_chkAnsageStateChanged
    
private void btnStartActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_btnStartActionPerformed
    if (radAdvanced.isSelected()) {
        try {
            Main.init(txtHost.getText(),
                    new StellwerkFile(new File(txtFile.getText())),
                    chkZza.isSelected(), chkAnsage.isSelected(),
                    chkAnsage.isSelected() ? chkAnsageEinfahrt.isSelected() : false,
                    chkAnsage.isSelected() ? chkAnsageAnschluesse.isSelected() : false,
                    chkAnsage.isSelected() ? chkAnsageVerspaetungen.isSelected() : false,
                    chkRis.isSelected());
        } catch (SAXException ex) {
            Logger.getLogger(BahnsteigSelector.class.getName()).log(Level.SEVERE, null, ex);
        } catch (ParserConfigurationException ex) {
            Logger.getLogger(BahnsteigSelector.class.getName()).log(Level.SEVERE, null, ex);
        } catch (IOException ex) {
            Logger.getLogger(BahnsteigSelector.class.getName()).log(Level.SEVERE, null, ex);
        }
    } else if (radSimple.isSelected()) {
        try {
            List<String> bahnsteige = new LinkedList();
            for (Object selected : lstBahnsteige.getSelectedValues()) {
                bahnsteige.add((String) selected);
            }
            Main.init(txtHost.getText(),
                    new SimpleConfig(txtBahnhofsname.getText(), bahnsteige),
                    chkZza.isSelected(), chkAnsage.isSelected(),
                    chkAnsage.isSelected() ? chkAnsageEinfahrt.isSelected() : false,
                    chkAnsage.isSelected() ? chkAnsageAnschluesse.isSelected() : false,
                    chkAnsage.isSelected() ? chkAnsageVerspaetungen.isSelected() : false,
                    chkRis.isSelected());
        } catch (SAXException ex) {
            Logger.getLogger(BahnsteigSelector.class.getName()).log(Level.SEVERE, null, ex);
        } catch (ParserConfigurationException ex) {
            Logger.getLogger(BahnsteigSelector.class.getName()).log(Level.SEVERE, null, ex);
        } catch (IOException ex) {
            Logger.getLogger(BahnsteigSelector.class.getName()).log(Level.SEVERE, null, ex);
        }
    }
    setVisible(false);
}//GEN-LAST:event_btnStartActionPerformed
    
private void btnCancelActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_btnCancelActionPerformed
    System.exit(0);
}//GEN-LAST:event_btnCancelActionPerformed
    
    public void setBahnsteige(Collection<String> bahnsteige) {
        lstBahnsteige.setListData(bahnsteige.toArray());
    }
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JButton btnBrowse;
    private javax.swing.JButton btnCancel;
    private javax.swing.JButton btnStart;
    private javax.swing.ButtonGroup buttonGroup1;
    private javax.swing.JCheckBox chkAnsage;
    private javax.swing.JCheckBox chkAnsageAnschluesse;
    private javax.swing.JCheckBox chkAnsageEinfahrt;
    private javax.swing.JCheckBox chkAnsageVerspaetungen;
    private javax.swing.JCheckBox chkRis;
    private javax.swing.JCheckBox chkZza;
    private javax.swing.JLabel jLabel1;
    private javax.swing.JLabel jLabel2;
    private javax.swing.JLabel jLabel3;
    private javax.swing.JLabel jLabel4;
    private javax.swing.JLabel jLabel5;
    private javax.swing.JLabel jLabel6;
    private javax.swing.JLabel jLabel7;
    private javax.swing.JPanel jPanel1;
    private javax.swing.JPanel jPanel2;
    private javax.swing.JScrollPane jScrollPane1;
    private javax.swing.JList lstBahnsteige;
    private javax.swing.JRadioButton radAdvanced;
    private javax.swing.JRadioButton radSimple;
    private javax.swing.JTextField txtBahnhofsname;
    private javax.swing.JTextField txtFile;
    private javax.swing.JTextField txtHost;
    // End of variables declaration//GEN-END:variables
}
