/*
 * Copyright 2011 Matthias Butz <mtz@mtz.cc>. All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without modification, are
 * permitted provided that the following conditions are met:
 *
 *   1. Redistributions of source code must retain the above copyright notice, this list of
 *      conditions and the following disclaimer.
 *
 *   2. Redistributions in binary form must reproduce the above copyright notice, this list
 *      of conditions and the following disclaimer in the documentation and/or other materials
 *      provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY MATTHIAS BUTZ ''AS IS'' AND ANY EXPRESS OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
 * FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL MATTHIAS BUTZ OR
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON
 * ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF
 * ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/

package cc.mtz.sts.zza.data;

import java.util.List;
import java.util.regex.Pattern;
import js.java.stspluginlib.PluginClient.ZugDetails;

/**
 *
 * @author Matze
 */
public class ZugRewrite {
    private String zug;
    private String simStart;
    private String simEnde;
    private String start;
    private String ende;
    private List<String> vias;

    public ZugRewrite() {
        
    }

    public ZugRewrite(String zug, String simStart, String simEnde, String start, String ende) {
        this.zug = zug;
        this.simStart = simStart;
        this.simEnde = simEnde;
        this.start = start;
        this.ende = ende;
    }
    
    public ZugRewrite(String zug, String simStart, String simEnde, String start, String ende, List<String> vias) {
        this.zug = zug;
        this.simStart = simStart;
        this.simEnde = simEnde;
        this.start = start;
        this.ende = ende;
        this.vias = vias;
    }

    public ZugRewrite(String zug, String simStart, String simEnde) {
        this.zug = zug;
        this.simStart = simStart;
        this.simEnde = simEnde;
    }

    public String getEnde() {
        return ende;
    }

    public void setEnde(String ende) {
        this.ende = ende;
    }

    public String getSimEnde() {
        return simEnde;
    }

    public void setSimEnde(String simEnde) {
        this.simEnde = simEnde;
    }

    public String getSimStart() {
        return simStart;
    }

    public void setSimStart(String simStart) {
        this.simStart = simStart;
    }

    public String getStart() {
        return start;
    }

    public void setStart(String start) {
        this.start = start;
    }

    public List<String> getVias() {
        return vias;
    }

    public void setVias(List<String> vias) {
        this.vias = vias;
    }

    public String getZug() {
        return zug;
    }

    public void setZug(String zug) {
        this.zug = zug;
    }

    public boolean matches(ZugDetails zug) {
        return Pattern.matches(this.zug, zug.name) && (Pattern.matches(simStart, zug.von) || zug.von == null) && (Pattern.matches(simEnde, zug.nach) || zug.nach == null);
    }

    public RewrittenDetails rewrite(ZugDetails zug) {
        RewrittenDetails rewritten = new RewrittenDetails(zug);
        if (start != null) {
            rewritten.von = start;
        }
        if (ende != null) {
            rewritten.nach = ende;
        }
        return rewritten;
    }
    
}
