/*
 * Copyright 2011 Matthias Butz <mtz@mtz.cc>. All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without modification, are
 * permitted provided that the following conditions are met:
 *
 *   1. Redistributions of source code must retain the above copyright notice, this list of
 *      conditions and the following disclaimer.
 *
 *   2. Redistributions in binary form must reproduce the above copyright notice, this list
 *      of conditions and the following disclaimer in the documentation and/or other materials
 *      provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY MATTHIAS BUTZ ''AS IS'' AND ANY EXPRESS OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
 * FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL MATTHIAS BUTZ OR
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON
 * ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF
 * ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/

package cc.mtz.sts.zza;

import cc.mtz.sts.zza.data.ZugRewrite;
import cc.mtz.sts.zza.data.Bahnhof;
import java.io.File;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

/**
 *
 * @author Matze
 */
public class StellwerkFile extends DefaultHandler {
    
    protected List<ZugRewrite> rewrites = new LinkedList();
    private ZugRewrite currentRewrite;
    protected Map<String, String> soundReplaces;
    protected List<Bahnhof> bahnhoefe = new LinkedList();
    private String crFind;
    private String crReplace;
    private StringBuilder chars = new StringBuilder();
    
    public StellwerkFile(File file) throws SAXException, ParserConfigurationException, IOException {
        SAXParserFactory spf = SAXParserFactory.newInstance();
        SAXParser sp = spf.newSAXParser();
        sp.parse(file, this);
    }
    
    protected StellwerkFile() {
        soundReplaces = new LinkedHashMap();
    }

    public List<ZugRewrite> getRewrites() {
        return rewrites;
    }

    public List<Bahnhof> getBahnhoefe() {
        return bahnhoefe;
    }

    public Map<String, String> getSoundReplaces() {
        return soundReplaces;
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (qName.equals("rewrite")) {
            rewrites.add(currentRewrite);
        } else if (qName.equals("via")) { 
            currentRewrite.getVias().add(chars.toString());
        } else if (qName.equals("replace")) {
            crReplace = chars.toString();
            soundReplaces.put(crFind, crReplace);
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        chars.append(ch, start, length);
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        chars = new StringBuilder();
        if (qName.equals("rewrite")) {
            currentRewrite = new ZugRewrite(
                    attributes.getValue(uri, "zug"),
                    attributes.getValue(uri, "simstart"),
                    attributes.getValue(uri, "simende"),
                    attributes.getValue(uri, "start"),
                    attributes.getValue(uri, "ende"),
                    new LinkedList()
                    );
        } else if (qName.equals("soundreplaces")) {
            soundReplaces = new LinkedHashMap();
        } else if (qName.equals("replace")) {
            crFind = attributes.getValue(uri, "find");
        } else if (qName.equals("bahnhof")) {
            bahnhoefe.add(new Bahnhof(attributes.getValue(uri, "name"), attributes.getValue(uri, "gleise"), attributes.getValue(uri, "ende")));
        }
    }
    
}
