/*
 * Copyright 2011 Matthias Butz <mtz@mtz.cc>. All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without modification, are
 * permitted provided that the following conditions are met:
 *
 *   1. Redistributions of source code must retain the above copyright notice, this list of
 *      conditions and the following disclaimer.
 *
 *   2. Redistributions in binary form must reproduce the above copyright notice, this list
 *      of conditions and the following disclaimer in the documentation and/or other materials
 *      provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY MATTHIAS BUTZ ''AS IS'' AND ANY EXPRESS OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
 * FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL MATTHIAS BUTZ OR
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON
 * ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF
 * ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
package cc.mtz.sts.zza;

import cc.mtz.sts.zza.sound.SoundPlayer;
import cc.mtz.sts.zza.listener.StsListener;
import cc.mtz.sts.zza.listener.ZzaManager;
import cc.mtz.sts.zza.listener.AnsageManager;
import cc.mtz.sts.zza.ui.BahnsteigSelector;
import java.io.File;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.xml.parsers.ParserConfigurationException;
import org.xml.sax.SAXException;

/**
 *
 * @author Matze
 */
public class Main {

    public static ScheduledExecutorService ses;
    public static PluginClientImpl client;
    private static final String VERSION = "1.0";
    public static final String IGNORE_PATTERN = "^(TEC|CS|RoLa|Lr|LR|IKL|CB|Tfzf|Ersatzlok|FE|CIL).*";

    public static void init(String host, StellwerkFile config,
            boolean zza, boolean ansage, boolean einfahrt, boolean anschluesse,
            boolean verspaetungen, boolean ris) throws SAXException, ParserConfigurationException, IOException {

        SoundPlayer.getInstance().start();
        Rewriter.init(config, ris);

        List<StsListener> listener = new LinkedList();
        if (zza) {
            listener.add(new ZzaManager());
        }
        if (ansage) {
            listener.add(new AnsageManager(config, einfahrt, anschluesse, verspaetungen));
        }

        client = new PluginClientImpl("Zugzielanzeiger + Bahnsteigansage",
                "Matthias Butz", VERSION, 
                "Dieses Plugin simuliert Zugzielanzeiger und automatische Bahnsteigansagen an einem oder mehreren Bahnhöfen innerhalb eines Stellwerks.", config,
                listener);
        client.connect(host);
        ses = new ScheduledThreadPoolExecutor(5);
        ses.scheduleWithFixedDelay(new Runnable() {

            public void run() {
                if (client.isReady()) {
                    client.requestZuege();
                }
            }
        }, 1, 1, TimeUnit.MINUTES);
    }

    /**
     * @param args the command line arguments
     */
    public static void main(final String[] args) throws IOException, SAXException, ParserConfigurationException {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        } catch (ClassNotFoundException ex) {
            Logger.getLogger(Main.class.getName()).log(Level.SEVERE, null, ex);
        } catch (InstantiationException ex) {
            Logger.getLogger(Main.class.getName()).log(Level.SEVERE, null, ex);
        } catch (IllegalAccessException ex) {
            Logger.getLogger(Main.class.getName()).log(Level.SEVERE, null, ex);
        } catch (UnsupportedLookAndFeelException ex) {
            Logger.getLogger(Main.class.getName()).log(Level.SEVERE, null, ex);
        }
        final BahnsteigSelector selector = new BahnsteigSelector();
        final ConfigClient client = new ConfigClient("ZZA Konfiguration", "Matthias Butz", VERSION, "Konfigurationsdialog für Zugzielanzeiger + Bahnsteigansage");
        client.connect("localhost");
        java.awt.EventQueue.invokeLater(new Runnable() {

            public void run() {
                selector.setVisible(true);
            }
        });
        synchronized (client) {
            try {
                client.wait();
            } catch (InterruptedException ex) {
            }
        }
        java.awt.EventQueue.invokeLater(new Runnable() {

            public void run() {
                selector.setBahnsteige(client.getBahnsteige());
            }
        });
        //client.close(); sometimes threaddeath occurs
    }
}
