/*
 * Copyright 2011 Matthias Butz <mtz@mtz.cc>. All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without modification, are
 * permitted provided that the following conditions are met:
 *
 *   1. Redistributions of source code must retain the above copyright notice, this list of
 *      conditions and the following disclaimer.
 *
 *   2. Redistributions in binary form must reproduce the above copyright notice, this list
 *      of conditions and the following disclaimer in the documentation and/or other materials
 *      provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY MATTHIAS BUTZ ''AS IS'' AND ANY EXPRESS OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
 * FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL MATTHIAS BUTZ OR
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON
 * ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF
 * ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/

package cc.mtz.sts.zza;

import cc.mtz.sts.zza.sound.SoundPlayer;
import cc.mtz.sts.zza.data.RewrittenDetails;
import cc.mtz.sts.zza.data.ZugBelegung;
import cc.mtz.sts.zza.data.DataCache;
import cc.mtz.sts.zza.data.Bahnhof;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;

/**
 *
 * @author Matze
 */
public class AnschlussAnsage implements Runnable {

    private String gleis;
    private int zid;
    private Bahnhof bahnhof;


    public AnschlussAnsage(String gleis, Bahnhof bahnhof, int zid) {
        this.gleis = gleis;
        this.zid = zid;
        this.bahnhof = bahnhof;
    }

    public void run() {
        try {
            DataCache cache = Main.client.getLastRunCache();
            StringBuilder ansage = new StringBuilder("Auf Gleis ");
            ansage.append(gleis.replaceFirst("[^0-9]*(.*)$", "$1"));
            ansage.append(" Willkommen in ");
            ansage.append(bahnhof.getName());
            ansage.append(". Eingefahrener  ");
            String vias = "";
            RewrittenDetails details = Rewriter.getInstance().rewrite(cache.getDetailCache().get(zid));
            ansage.append(AnsagenUtil.ansagenName(details.name));
            if (details.nach == null || Pattern.matches(bahnhof.getEndeRegex(), details.nach)) {
                ansage.append(" endet hier");
            } else {
                ansage.append(" f\u00e4hrt weiter nach ");
                ansage.append(details.nach);
                if (!vias.isEmpty()) {
                    ansage.append(" via ");
                    ansage.append(vias);
                }
            }
            ansage.append(". Ihre n\u00e4chsten Anschl\u00fcsse: ");
            // anschluss = in den nächsten 15 minuten plan + in den nächsten 15 minuten verspätet
            for (String nachbargleis : cache.getBelegung().keySet()) {
                if (Pattern.matches(bahnhof.getGleiseRegex(), nachbargleis) && !nachbargleis.equals(gleis)) {
                    List<ZugBelegung> zuege = cache.getBelegung().get(nachbargleis);
                    Collections.sort(zuege, new ZugBelegung.DelayComparator());
                    for (ZugBelegung planzug : zuege) {
                        if (Pattern.matches(Main.IGNORE_PATTERN, planzug.zug.name)) {
                            continue;
                        }
                        if (planzug.zeile.ab > 0 && (planzug.zeile.ab <= Main.client.getSimutime() + 60000 * 15 || planzug.zeile.ab + planzug.zug.verspaetung * 60000 <= Main.client.getSimutime() + 60000 * 15) && !Pattern.matches(bahnhof.getEndeRegex(), planzug.zug.nach)) {
                            // fährt in den nächsten 15 minuten oder FRÜHER
                            details = Rewriter.getInstance().rewrite(cache.getDetailCache().get(planzug.zug.zid));
                            if (planzug.zug.verspaetung >= 5) {
                                ansage.append("Versp\u00e4teter ");
                            }
                            ansage.append(AnsagenUtil.ansagenName(planzug.zug.name));
                            ansage.append(" nach ");
                            ansage.append(details.nach);
                            ansage.append(" Abfahrt ");
                            if (planzug.zug.verspaetung >= 5) {
                                ansage.append("heute voraussichtlich ");
                                ansage.append((int) ((planzug.zeile.ab + planzug.zug.verspaetung * 60000) / 60000) / 60);
                                ansage.append(":");
                                ansage.append((int) ((planzug.zeile.ab + planzug.zug.verspaetung * 60000) / 60000) % 60);
                                ansage.append(" Uhr");
                            } else {
                                ansage.append(planzug.zeile.getFormattedAb());
                                ansage.append(" Uhr");
                            }
                            ansage.append(" von Gleis ");
                            ansage.append(nachbargleis.replaceFirst("[^0-9]*(.*)$", "$1"));
                            ansage.append(". ");
                        }
                    }
                }
            }
            SoundPlayer.getInstance().addText(SoundPlayer.Priority.MEDIUM, ansage.toString());
            synchronized (SoundPlayer.getInstance()) {
                SoundPlayer.getInstance().notify();
            }
        } catch (Exception ex) {
            Logger.getAnonymousLogger().log(Level.WARNING, "AnschlussAnsage", ex);
        }
    }
}
