/*
 * Decompiled with CFR 0.152.
 */
package cc.mtz.sts.zza.sound;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.PriorityBlockingQueue;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.SourceDataLine;
import javax.sound.sampled.UnsupportedAudioFileException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SoundPlayer
extends Thread {
    private final Queue<PlayEntry> toPlay = new PriorityBlockingQueue<PlayEntry>();
    private Map<String, String> replaces = new LinkedHashMap<String, String>();
    private static SoundPlayer instance = new SoundPlayer();

    public static SoundPlayer getInstance() {
        return instance;
    }

    private SoundPlayer() {
        this.replaces.put("0([0-9]):", "$1:");
        this.replaces.put(":0([0-9])", ":$1");
        this.replaces.put("([0-9]*):([0-9]*) Uhr", "$1 Uhr $2");
        this.replaces.put("Uhr 0([^0-9]*)", "Uhr$1");
        this.replaces.put("ICE", "Ih zeh eh");
        this.replaces.put("IC", "Ih zeh");
        this.replaces.put("EC", "Eh zeh");
        this.replaces.put("THA", "Thalys");
        this.replaces.put("IRE", "Ih er eh");
        this.replaces.put("RE", "Er eh");
        this.replaces.put("RB", "Er beh");
        this.replaces.put("Hbf", "Hauptbahnhof");
        this.replaces.put("HB", "Hauptbahnhof");
        this.replaces.put("Bad Bf", "Badischer Bahnhof");
        this.replaces.put("Bf", "Bahnhof");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addText(Priority priority, String text) {
        for (Map.Entry<String, String> replace : this.replaces.entrySet()) {
            text = text.replaceAll(replace.getKey(), replace.getValue());
        }
        Queue<PlayEntry> queue = this.toPlay;
        synchronized (queue) {
            this.toPlay.add(new PlayEntry(priority, text));
        }
    }

    public void addReplaces(Map<String, String> replaces) {
        this.replaces.putAll(replaces);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isIdle() {
        Queue<PlayEntry> queue = this.toPlay;
        synchronized (queue) {
            return this.toPlay.isEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        while (true) {
            AudioInputStream inStream = null;
            try {
                String playText;
                while (this.toPlay.isEmpty()) {
                    try {
                        SoundPlayer soundPlayer = this;
                        synchronized (soundPlayer) {
                            this.wait();
                        }
                    }
                    catch (InterruptedException ex) {
                        Logger.getLogger(SoundPlayer.class.getName()).log(Level.SEVERE, null, ex);
                    }
                }
                Queue<PlayEntry> queue = this.toPlay;
                synchronized (queue) {
                    playText = this.toPlay.poll().getText();
                }
                inStream = AudioSystem.getAudioInputStream(new URL("http://picard.mtztech.info/blechelse.php?text=" + URLEncoder.encode(playText, "ISO-8859-1")));
                AudioFormat sourceFormat = inStream.getFormat();
                AudioFormat targetFormat = new AudioFormat(AudioFormat.Encoding.PCM_SIGNED, sourceFormat.getSampleRate(), 16, sourceFormat.getChannels(), sourceFormat.getChannels() * 2, sourceFormat.getSampleRate(), false);
                AudioInputStream gongStream = AudioSystem.getAudioInputStream(new File("gong.wav"));
                AudioFormat gongFormat = gongStream.getFormat();
                AudioFormat gongTargetFormat = new AudioFormat(AudioFormat.Encoding.PCM_SIGNED, gongFormat.getSampleRate(), 16, gongFormat.getChannels(), gongFormat.getChannels() * 2, gongFormat.getSampleRate(), false);
                SourceDataLine gongLine = AudioSystem.getSourceDataLine(gongTargetFormat);
                gongLine.open();
                gongLine.start();
                byte[] buffer = new byte[128000];
                int bytesfilled = -1;
                do {
                    if ((bytesfilled = gongStream.read(buffer)) <= -1) continue;
                    gongLine.write(buffer, 0, bytesfilled);
                } while (bytesfilled > -1);
                gongLine.drain();
                gongLine.stop();
                gongLine.close();
                gongStream.close();
                SourceDataLine line = AudioSystem.getSourceDataLine(targetFormat);
                line.open();
                line.start();
                do {
                    if ((bytesfilled = inStream.read(buffer)) <= -1) continue;
                    line.write(buffer, 0, bytesfilled);
                } while (bytesfilled > -1);
                line.drain();
                line.stop();
                line.close();
                inStream.close();
                continue;
            }
            catch (LineUnavailableException ex) {
                Logger.getLogger(SoundPlayer.class.getName()).log(Level.SEVERE, null, ex);
                continue;
            }
            catch (UnsupportedAudioFileException ex) {
                Logger.getLogger(SoundPlayer.class.getName()).log(Level.SEVERE, null, ex);
                continue;
            }
            catch (IOException ex) {
                Logger.getLogger(SoundPlayer.class.getName()).log(Level.SEVERE, null, ex);
                continue;
            }
            finally {
                try {
                    inStream.close();
                }
                catch (IOException ex) {
                    Logger.getLogger(SoundPlayer.class.getName()).log(Level.SEVERE, null, ex);
                }
                continue;
            }
            break;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class PlayEntry
    implements Comparable<PlayEntry> {
        private String text;
        private Priority priority;

        public PlayEntry(Priority priority, String text) {
            this.priority = priority;
            this.text = text;
        }

        @Override
        public int compareTo(PlayEntry o) {
            return this.priority.compareTo(o.priority);
        }

        public String getText() {
            return this.text;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Priority implements Comparable<Priority>
    {
        HIGH,
        MEDIUM,
        LOW;

    }
}

