/*
 * Decompiled with CFR 0.152.
 */
package cc.mtz.sts.zza;

import cc.mtz.sts.zza.ConfigClient;
import cc.mtz.sts.zza.PluginClientImpl;
import cc.mtz.sts.zza.Rewriter;
import cc.mtz.sts.zza.StellwerkFile;
import cc.mtz.sts.zza.listener.AnsageManager;
import cc.mtz.sts.zza.listener.StsListener;
import cc.mtz.sts.zza.listener.ZzaManager;
import cc.mtz.sts.zza.sound.SoundPlayer;
import cc.mtz.sts.zza.ui.BahnsteigSelector;
import java.awt.EventQueue;
import java.io.IOException;
import java.util.LinkedList;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.xml.parsers.ParserConfigurationException;
import org.xml.sax.SAXException;

public class Main {
    public static ScheduledExecutorService ses;
    public static PluginClientImpl client;
    private static final String VERSION = "1.0";
    public static final String IGNORE_PATTERN = "^(TEC|CS|RoLa|Lr|LR|IKL|CB|Tfzf|Ersatzlok|FE|CIL).*";

    public static void init(String host, StellwerkFile config, boolean zza, boolean ansage, boolean einfahrt, boolean anschluesse, boolean verspaetungen, boolean ris) throws SAXException, ParserConfigurationException, IOException {
        SoundPlayer.getInstance().start();
        Rewriter.init(config, ris);
        LinkedList<StsListener> listener = new LinkedList<StsListener>();
        if (zza) {
            listener.add(new ZzaManager());
        }
        if (ansage) {
            listener.add(new AnsageManager(config, einfahrt, anschluesse, verspaetungen));
        }
        client = new PluginClientImpl("Zugzielanzeiger + Bahnsteigansage", "Matthias Butz", VERSION, "Dieses Plugin simuliert Zugzielanzeiger und automatische Bahnsteigansagen an einem oder mehreren Bahnh\u00f6fen innerhalb eines Stellwerks.", config, listener);
        client.connect(host);
        ses = new ScheduledThreadPoolExecutor(5);
        ses.scheduleWithFixedDelay(new Runnable(){

            public void run() {
                if (client.isReady()) {
                    client.requestZuege();
                }
            }
        }, 1L, 1L, TimeUnit.MINUTES);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws IOException, SAXException, ParserConfigurationException {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (ClassNotFoundException ex) {
            Logger.getLogger(Main.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (InstantiationException ex) {
            Logger.getLogger(Main.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IllegalAccessException ex) {
            Logger.getLogger(Main.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (UnsupportedLookAndFeelException ex) {
            Logger.getLogger(Main.class.getName()).log(Level.SEVERE, null, ex);
        }
        final BahnsteigSelector selector = new BahnsteigSelector();
        final ConfigClient client = new ConfigClient("ZZA Konfiguration", "Matthias Butz", VERSION, "Konfigurationsdialog f\u00fcr Zugzielanzeiger + Bahnsteigansage");
        client.connect("localhost");
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                selector.setVisible(true);
            }
        });
        ConfigClient configClient = client;
        synchronized (configClient) {
            try {
                client.wait();
            }
            catch (InterruptedException ex) {
                // empty catch block
            }
        }
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                selector.setBahnsteige(client.getBahnsteige());
            }
        });
    }
}

