/*
 * Decompiled with CFR 0.152.
 */
package marytts.tools.install;

import java.net.MalformedURLException;
import javax.xml.parsers.ParserConfigurationException;
import marytts.tools.install.ComponentDescription;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class VoiceComponentDescription
extends ComponentDescription {
    private String gender;
    private String type;
    private String dependsLanguage;
    private String dependsVersion;

    @Override
    public void replaceWithUpdate() {
        VoiceComponentDescription update = (VoiceComponentDescription)this.getAvailableUpdate();
        if (update == null) {
            return;
        }
        this.gender = update.gender;
        this.type = update.type;
        this.dependsLanguage = update.dependsLanguage;
        this.dependsVersion = update.dependsVersion;
        super.replaceWithUpdate();
    }

    public VoiceComponentDescription(String name, String version, String packageFilename) {
        super(name, version, packageFilename);
    }

    public VoiceComponentDescription(Element xmlDescription) throws NullPointerException, MalformedURLException {
        super(xmlDescription);
        this.gender = xmlDescription.getAttribute("gender");
        this.type = xmlDescription.getAttribute("type");
        Element dependsElement = (Element)xmlDescription.getElementsByTagName("depends").item(0);
        this.dependsLanguage = dependsElement.getAttribute("language");
        this.dependsVersion = dependsElement.getAttribute("version");
    }

    @Override
    public String getComponentTypeString() {
        return "voice";
    }

    public String getGender() {
        return this.gender;
    }

    public void setGender(String aGender) {
        this.gender = aGender;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String aType) {
        this.type = aType;
    }

    public String getDependsLanguage() {
        return this.dependsLanguage;
    }

    public void setDependsLanguage(String aLanguage) {
        this.dependsLanguage = aLanguage;
    }

    public String getDependsVersion() {
        return this.dependsVersion;
    }

    public void setDependsVersion(String aVersion) {
        this.dependsVersion = aVersion;
    }

    @Override
    public Document createComponentXML() throws ParserConfigurationException {
        Document doc = super.createComponentXML();
        NodeList nodes = doc.getElementsByTagName(this.getComponentTypeString());
        assert (nodes.getLength() == 1);
        Element voiceElt = (Element)nodes.item(0);
        voiceElt.setAttribute("type", this.type);
        voiceElt.setAttribute("gender", this.gender);
        Element dependsElt = (Element)voiceElt.appendChild(doc.createElementNS("http://mary.dfki.de/installer", "depends"));
        dependsElt.setAttribute("language", this.dependsLanguage);
        dependsElt.setAttribute("version", this.dependsVersion);
        return doc;
    }
}

