/*
 * Decompiled with CFR 0.152.
 */
package marytts.tools.install;

import com.twmacinta.util.MD5;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FilenameFilter;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Locale;
import java.util.TreeMap;
import java.util.TreeSet;
import marytts.tools.install.ComponentDescription;
import marytts.tools.install.InstallFileParser;
import marytts.tools.install.LanguageComponentDescription;
import marytts.tools.install.VoiceComponentDescription;
import marytts.util.MaryUtils;
import marytts.util.dom.DomUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class CreateComponentXML {
    public static final String PROPERTY_XML_FOLDER = "mary.componentXML.folder";
    public static final String PROPERTY_XML_OUTPUTFILE = "mary.componentXML.outputfile";

    public static void main(String[] args) throws Exception {
        if (System.getProperty(PROPERTY_XML_OUTPUTFILE) == null) {
            System.out.println("You can indicate a single output file for the generated XML with -Dmary.componentXML.outputfile=(filename)");
            System.out.println();
        }
        if (System.getProperty(PROPERTY_XML_FOLDER) == null) {
            System.out.println("You can indicate a folder containing existing component XML files with -Dmary.componentXML.folder=(foldername)");
            System.out.println();
        }
        boolean writeIndividualXML = true;
        File outputFile = null;
        Document allXML = null;
        String outputFilename = System.getProperty(PROPERTY_XML_OUTPUTFILE);
        if (outputFilename != null) {
            outputFile = new File(outputFilename);
            writeIndividualXML = false;
        }
        HashSet<File> xmlFolders = new HashSet<File>();
        boolean haveCustomXMLFolder = false;
        String customXMLFolder = System.getProperty(PROPERTY_XML_FOLDER);
        if (customXMLFolder != null) {
            haveCustomXMLFolder = true;
            File custom = new File(customXMLFolder);
            if (!custom.isDirectory()) {
                throw new FileNotFoundException("Custom XML folder '" + customXMLFolder + "' was specified in system properties but does not exist!");
            }
            xmlFolders.add(custom);
        } else {
            File installedFolder;
            xmlFolders.add(new File("."));
            File downloadFolder = new File("./download");
            if (downloadFolder.isDirectory()) {
                xmlFolders.add(downloadFolder);
            }
            if ((installedFolder = new File("./installed")).isDirectory()) {
                xmlFolders.add(installedFolder);
            }
        }
        ArrayList<File> zips = new ArrayList<File>(args.length);
        for (String a : args) {
            File f = new File(a);
            if (!f.canRead()) {
                throw new FileNotFoundException("Cannot read file: " + a);
            }
            if (!f.getName().startsWith("mary-") || !f.getName().endsWith(".zip")) {
                throw new IllegalArgumentException("File '" + f.getName() + " doesn't follow convention 'mary-(name)-(version).zip'");
            }
            zips.add(f);
            if (haveCustomXMLFolder) continue;
            xmlFolders.add(f.getAbsoluteFile().getParentFile());
        }
        TreeMap<String, ComponentDescription> knownComponents = new TreeMap<String, ComponentDescription>();
        for (File folder : xmlFolders) {
            File[] xmlFiles;
            for (File xmlFile : xmlFiles = folder.listFiles(new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    return name.endsWith(".xml");
                }
            })) {
                try {
                    InstallFileParser ifp = new InstallFileParser(xmlFile.toURI().toURL());
                    for (ComponentDescription componentDescription : ifp.getLanguageDescriptions()) {
                        knownComponents.put(componentDescription.getName(), componentDescription);
                    }
                    for (ComponentDescription componentDescription : ifp.getVoiceDescriptions()) {
                        knownComponents.put(componentDescription.getName(), componentDescription);
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
        }
        System.out.print("Loaded known component descriptions: ");
        for (String componentName : knownComponents.keySet()) {
            System.out.print(componentName + "(" + ((ComponentDescription)knownComponents.get(componentName)).getVersion() + ") ");
        }
        System.out.println();
        System.out.println();
        TreeSet newDescriptions = new TreeSet();
        HashSet<Locale> existingLocales = new HashSet<Locale>(Arrays.asList(Locale.getAvailableLocales()));
        existingLocales.add(new Locale("te"));
        for (File zip : zips) {
            ComponentDescription cd;
            String version;
            String name;
            String filename = zip.getName();
            assert (filename.startsWith("mary-"));
            int nameStart = "mary-".length();
            int versionEnd = filename.length() - ".zip".length();
            int n = filename.lastIndexOf(45, versionEnd);
            if (n != -1) {
                name = filename.substring(nameStart, n);
                version = filename.substring(n + 1, versionEnd);
            } else {
                name = filename.substring(nameStart, versionEnd);
                version = "unknown";
            }
            Locale l = MaryUtils.string2locale(name);
            boolean isLanguageComponent = existingLocales.contains(l);
            boolean haveKnownComponent = knownComponents.containsKey(name);
            System.out.println((isLanguageComponent ? "Language" : "Voice") + " component " + name + ", version " + version + (haveKnownComponent ? " (have component description for version " + ((ComponentDescription)knownComponents.get(name)).getVersion() + ")" : ""));
            if (isLanguageComponent) {
                cd = new LanguageComponentDescription(name, version, filename);
                cd.setLocale(MaryUtils.string2locale(name));
            } else {
                VoiceComponentDescription vcd = new VoiceComponentDescription(name, version, filename);
                if (haveKnownComponent) {
                    VoiceComponentDescription old = (VoiceComponentDescription)knownComponents.get(name);
                    vcd.setGender(old.getGender());
                    vcd.setType(old.getType());
                    vcd.setDependsLanguage(old.getDependsLanguage());
                    vcd.setDependsVersion(old.getDependsVersion());
                    vcd.setLocale(old.getLocale());
                } else {
                    vcd.setGender("unknown");
                    vcd.setType("unknown");
                    vcd.setDependsLanguage("unknown");
                    vcd.setDependsVersion(version);
                    vcd.setLocale(new Locale("unknown"));
                }
                cd = vcd;
            }
            cd.setPackageSize((int)zip.length());
            cd.setPackageMD5Sum(MD5.asHex(MD5.getHash(zip)));
            if (haveKnownComponent) {
                ComponentDescription old = (ComponentDescription)knownComponents.get(name);
                cd.setDescription(old.getDescription());
                cd.setLicenseURL(old.getLicenseURL());
                for (URL loc : old.getLocations()) {
                    cd.addLocation(loc);
                }
            } else {
                cd.setDescription(" ");
                if (isLanguageComponent) {
                    cd.setLicenseURL(new URL("http://www.gnu.org/licenses/lgpl-3.0-standalone.html"));
                } else {
                    cd.setLicenseURL(new URL("http://mary.dfki.de/download/by-nd-3.0.html"));
                }
                cd.addLocation(new URL("http://mary.dfki.de/download/" + version + "/" + filename));
            }
            Document oneXML = cd.createComponentXML();
            if (writeIndividualXML) {
                File oneXMLFile = new File(zip.getParentFile(), "mary-" + name + "-" + version + "-component.xml");
                DomUtils.document2File(oneXML, oneXMLFile);
                System.out.println("Wrote " + oneXMLFile.getPath());
                continue;
            }
            if (allXML == null) {
                allXML = oneXML;
                continue;
            }
            Node compDesc = oneXML.getDocumentElement().getElementsByTagName(cd.getComponentTypeString()).item(0);
            allXML.getDocumentElement().appendChild(allXML.adoptNode(compDesc));
        }
        if (!writeIndividualXML && allXML != null) {
            DomUtils.document2File(allXML, outputFile);
            System.out.println("Wrote " + outputFile.getPath());
        }
    }
}

