/*
 * Decompiled with CFR 0.152.
 */
package marytts.signalproc.sinusoidal.hntm.analysis;

import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.IOException;
import java.nio.ByteBuffer;
import marytts.signalproc.analysis.RegularizedPostWarpedCepstrumEstimator;
import marytts.signalproc.analysis.RegularizedPreWarpedCepstrumEstimator;
import marytts.signalproc.sinusoidal.hntm.analysis.HntmAnalyzerParams;
import marytts.signalproc.window.GaussWindow;
import marytts.util.math.ArrayUtils;
import marytts.util.math.ComplexNumber;
import marytts.util.math.MathUtils;

public class FrameHarmonicPart {
    public ComplexNumber[] complexAmps = null;

    public FrameHarmonicPart() {
    }

    public FrameHarmonicPart(FrameHarmonicPart existing) {
        this();
        if (existing != null) {
            this.complexAmps = ArrayUtils.copy(existing.complexAmps);
        }
    }

    public FrameHarmonicPart(DataInputStream dis, int numHarmonics) {
        if (numHarmonics > 0) {
            this.complexAmps = new ComplexNumber[numHarmonics];
            for (int i = 0; i < this.complexAmps.length; ++i) {
                try {
                    this.complexAmps[i] = new ComplexNumber(dis.readFloat(), dis.readFloat());
                    continue;
                }
                catch (IOException e) {
                    this.complexAmps[i] = null;
                }
            }
        }
    }

    public FrameHarmonicPart(ByteBuffer bb, int numHarmonics) {
        if (numHarmonics > 0) {
            this.complexAmps = new ComplexNumber[numHarmonics];
            for (int i = 0; i < this.complexAmps.length; ++i) {
                try {
                    this.complexAmps[i] = new ComplexNumber(bb.getFloat(), bb.getFloat());
                    continue;
                }
                catch (Exception e) {
                    this.complexAmps[i] = null;
                }
            }
        }
    }

    public boolean equals(FrameHarmonicPart other) {
        if (this.complexAmps != null || other.complexAmps != null) {
            if (this.complexAmps != null && other.complexAmps == null) {
                return false;
            }
            if (this.complexAmps == null && other.complexAmps != null) {
                return false;
            }
            if (this.complexAmps.length != other.complexAmps.length) {
                return false;
            }
            for (int i = 0; i < this.complexAmps.length; ++i) {
                if (this.complexAmps[i].equals(other.complexAmps[i])) continue;
                return false;
            }
        }
        return true;
    }

    public int getLength() {
        int len = 0;
        if (this.complexAmps != null && this.complexAmps.length > 0) {
            len = this.complexAmps.length;
        }
        return 8 * len;
    }

    public void write(DataOutput out) throws IOException {
        int numHarmonics = 0;
        if (this.complexAmps != null && this.complexAmps.length > 0) {
            numHarmonics = this.complexAmps.length;
        }
        if (numHarmonics > 0) {
            for (int i = 0; i < this.complexAmps.length; ++i) {
                out.writeFloat(this.complexAmps[i].real);
                out.writeFloat(this.complexAmps[i].imag);
            }
        }
    }

    public float[] getCeps(double f0InHz, int samplingRateInHz, HntmAnalyzerParams params) {
        float[] ceps = null;
        if (this.complexAmps != null) {
            double[] linearAmps = new double[this.complexAmps.length];
            double[] freqsInHz = new double[this.complexAmps.length];
            for (int j = 0; j < this.complexAmps.length; ++j) {
                freqsInHz[j] = (double)(j + 1) * f0InHz;
                linearAmps[j] = MathUtils.magnitudeComplex(this.complexAmps[j]);
            }
            double[] harmonicWeights = null;
            if (params.useWeightingInRegularizedCepstrumEstimationHarmonic) {
                GaussWindow g = new GaussWindow(2 * linearAmps.length);
                g.normalizeRange(0.1f, 1.0f);
                harmonicWeights = g.getCoeffsRightHalf();
            }
            if (params.regularizedCepstrumWarpingMethod == 1) {
                ceps = RegularizedPreWarpedCepstrumEstimator.freqsLinearAmps2cepstrum(linearAmps, freqsInHz, samplingRateInHz, params.harmonicPartCepstrumOrder, harmonicWeights, params.regularizedCepstrumLambdaHarmonic);
            } else if (params.regularizedCepstrumWarpingMethod == 2) {
                ceps = RegularizedPostWarpedCepstrumEstimator.freqsLinearAmps2cepstrum(linearAmps, freqsInHz, samplingRateInHz, params.harmonicPartCepstrumOrderPreMel, params.harmonicPartCepstrumOrder, harmonicWeights, (double)params.regularizedCepstrumLambdaHarmonic);
            }
        }
        return ceps;
    }

    public double[] getLinearAmps() {
        if (this.complexAmps != null) {
            return MathUtils.magnitudeComplex(this.complexAmps);
        }
        return null;
    }

    public double[] getDBAmps() {
        return MathUtils.amp2db(this.getLinearAmps());
    }

    public double[] getPhasesInRadians() {
        double[] phasesInRadians = null;
        if (this.complexAmps != null) {
            phasesInRadians = new double[this.complexAmps.length];
            for (int k = 0; k < this.complexAmps.length; ++k) {
                phasesInRadians[k] = MathUtils.phaseInRadians(this.complexAmps[k]);
            }
        }
        return phasesInRadians;
    }
}

