/*
 * Decompiled with CFR 0.152.
 */
package marytts.signalproc.process;

import java.io.IOException;
import java.io.InputStream;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.UnsupportedAudioFileException;
import marytts.signalproc.process.InlineDataProcessor;
import marytts.util.data.audio.AudioDoubleDataSource;
import marytts.util.signal.SignalProcUtils;

public class AudioMixer
implements InlineDataProcessor {
    private int silenceStart;
    private int silenceInBetween;
    private int samplingRate;
    AudioDoubleDataSource mixSignalSource;
    double[] mixSignal;
    int mixStart;
    double mixAmount;
    double oneMinusMixAmount;
    int bufferSize;
    int quarterBufferSize;
    double dataEn;
    double mixEn;
    double scale;
    double avgEn;
    double[] frm;
    boolean bFixed;
    double dataEnLongTerm;
    int enLongTermSize;
    double[] enLongTermBuff;
    int enLongTermInd;
    boolean bFirstEnBuff;

    public AudioMixer(InputStream inputStream, double stSil, double stBwn, int fs, int buffSize, double amount, boolean isFixed) {
        AudioInputStream inputAudio = null;
        try {
            inputAudio = AudioSystem.getAudioInputStream(inputStream);
        }
        catch (UnsupportedAudioFileException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (inputAudio != null) {
            int mixFs = (int)inputAudio.getFormat().getSampleRate();
            this.mixSignalSource = new AudioDoubleDataSource(inputAudio);
            this.samplingRate = fs;
            if (mixFs != fs) {
                System.out.println("Error! Sampling rates do not match, will not do any modificaiton on input");
                this.mixSignalSource = null;
            } else {
                int i;
                this.silenceStart = (int)Math.floor(stSil * (double)this.samplingRate + 0.5);
                this.silenceInBetween = (int)Math.floor(stBwn * (double)this.samplingRate + 0.5);
                this.silenceStart = Math.max(0, this.silenceStart);
                this.silenceInBetween = Math.max(0, this.silenceInBetween);
                this.mixSignal = new double[(int)this.mixSignalSource.getDataLength() + this.silenceInBetween];
                this.mixSignalSource.getData(this.mixSignal);
                this.avgEn = SignalProcUtils.getAverageSampleEnergy(this.mixSignal, (int)this.mixSignalSource.getDataLength());
                for (i = (int)this.mixSignalSource.getDataLength(); i < (int)this.mixSignalSource.getDataLength() + this.silenceInBetween; ++i) {
                    this.mixSignal[i] = 0.0;
                }
                this.mixStart = 0;
                this.mixAmount = amount;
                this.mixAmount = Math.max(this.mixAmount, 0.0);
                this.mixAmount = Math.min(this.mixAmount, 1.0);
                this.oneMinusMixAmount = 1.0 - this.mixAmount;
                this.bufferSize = buffSize;
                this.quarterBufferSize = (int)Math.floor((double)this.bufferSize * 0.25 + 0.5);
                this.frm = new double[this.bufferSize];
                this.bFixed = isFixed;
                this.scale = 1.0;
                this.enLongTermSize = 40;
                this.enLongTermBuff = new double[this.enLongTermSize];
                for (i = 0; i < this.enLongTermSize; ++i) {
                    this.enLongTermBuff[i] = 0.0;
                }
                this.bFirstEnBuff = true;
                this.enLongTermInd = -1;
            }
        } else {
            this.mixSignalSource = null;
        }
    }

    @Override
    public void applyInline(double[] data, int pos, int len) {
        if (data.length == this.bufferSize) {
            int i;
            for (i = 0; i < this.bufferSize; ++i) {
                this.frm[i] = this.mixSignal[(this.mixStart + i) % this.mixSignal.length];
            }
            if (!this.bFixed) {
                this.dataEn = Math.sqrt(SignalProcUtils.getAverageSampleEnergy(data));
                this.mixEn = Math.sqrt(SignalProcUtils.getAverageSampleEnergy(this.frm));
                this.scale = this.dataEn / this.mixEn;
            } else {
                this.dataEn = Math.sqrt(SignalProcUtils.getAverageSampleEnergy(data));
                ++this.enLongTermInd;
                if (this.bFirstEnBuff) {
                    if (this.enLongTermInd < this.enLongTermSize) {
                        this.enLongTermBuff[this.enLongTermInd] = this.dataEn;
                    }
                    if (this.enLongTermInd == this.enLongTermSize - 1) {
                        this.bFirstEnBuff = false;
                        this.enLongTermInd = -1;
                    }
                }
                this.dataEnLongTerm = 0.0;
                for (i = 0; i < this.enLongTermSize; ++i) {
                    this.dataEnLongTerm += this.enLongTermBuff[i];
                }
                this.dataEnLongTerm /= (double)this.enLongTermSize;
                this.scale = 0.25 * this.dataEnLongTerm / this.avgEn;
            }
            for (i = 0; i < this.bufferSize; ++i) {
                data[i] = this.oneMinusMixAmount * data[i] + this.mixAmount * this.scale * this.frm[i];
            }
            this.mixStart += this.quarterBufferSize;
        }
    }
}

