/*
 * Decompiled with CFR 0.152.
 */
package de.dfki.lt.tools.tokenizer;

import de.dfki.lt.tools.tokenizer.FileTools;
import de.dfki.lt.tools.tokenizer.JTok;
import de.dfki.lt.tools.tokenizer.LanguageResource;
import de.dfki.lt.tools.tokenizer.regexp.RegExp;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AbbrevCollector {
    private static final Logger LOG = LoggerFactory.getLogger(AbbrevCollector.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void collect(String dir, String suffix, String encoding, String resultFileName, String lang) throws IOException {
        JTok jtok = new JTok();
        LanguageResource langRes = jtok.getLanguageResource(lang);
        HashMap abbrevLists = langRes.getAbbrevLists();
        Set<String> nonCapTerms = langRes.getNonCapTerms();
        RegExp abbrevMatcher = langRes.getAbbrevMatcher();
        RegExp initialMatcher = langRes.getInitialMatcher();
        HashSet<String> abbrevs = new HashSet<String>();
        List trainingFiles = FileTools.getFilesFromDir(dir, suffix);
        for (String oneFileName : trainingFiles) {
            String sent;
            LOG.info("processing " + oneFileName + " ...");
            BufferedReader in = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(oneFileName), encoding));
            while ((sent = in.readLine()) != null) {
                String[] tokens = sent.split(" |\\.\\.\\.|\\.\\.|'|`|\\(|\\)|[|]");
                for (int i = 0; i < tokens.length - 1; ++i) {
                    String oneTok = tokens[i];
                    if (oneTok.length() <= 1 || !oneTok.endsWith(".")) continue;
                    int hyphenPos = oneTok.lastIndexOf("-");
                    if (hyphenPos != -1) {
                        oneTok = oneTok.substring(hyphenPos + 1);
                    }
                    if (abbrevMatcher.matches(oneTok) || initialMatcher.matches(oneTok)) continue;
                    boolean found = false;
                    for (String abbrevClass : abbrevLists.keySet()) {
                        Set oneList = (Set)abbrevLists.get(abbrevClass);
                        if (!oneList.contains(oneTok)) continue;
                        found = true;
                        break;
                    }
                    if (found) continue;
                    char firstChar = oneTok.charAt(0);
                    String tempTok = (firstChar = Character.toUpperCase(firstChar)) + oneTok.substring(1, oneTok.length() - 1);
                    if (nonCapTerms.contains(tempTok)) continue;
                    abbrevs.add(oneTok);
                }
            }
            in.close();
        }
        ArrayList sortedAbbrevs = new ArrayList(abbrevs);
        Collections.sort(sortedAbbrevs);
        PrintWriter out = null;
        try {
            out = new PrintWriter(new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(resultFileName), "utf-8")));
            for (String oneAbbrev : sortedAbbrevs) {
                out.println(oneAbbrev);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (null != out) {
                out.close();
            }
        }
    }

    public static void main(String[] args) {
        if (args.length != 5) {
            System.err.println("wrong number of arguments");
            System.exit(1);
        }
        try {
            AbbrevCollector.collect(args[0], args[1], args[2], args[3], args[4]);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

