/*
 * Decompiled with CFR 0.152.
 */
package cc.mtz.sts.zza.listener;

import cc.mtz.sts.zza.Main;
import cc.mtz.sts.zza.Rewriter;
import cc.mtz.sts.zza.StellwerkFile;
import cc.mtz.sts.zza.Util;
import cc.mtz.sts.zza.data.Bahnhof;
import cc.mtz.sts.zza.data.DataCache;
import cc.mtz.sts.zza.data.RewrittenDetails;
import cc.mtz.sts.zza.data.ZugBelegung;
import cc.mtz.sts.zza.listener.StsListener;
import cc.mtz.sts.zza.sound.SoundPlayer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import js.java.stspluginlib.PluginClient;

public class AnsageManager
implements StsListener {
    private StellwerkFile config;
    private Map<String, Map<String, Long>> verspaetungsAnsageZeiten = new HashMap<String, Map<String, Long>>();
    private Map<String, Map<String, Long>> gleiswechselAnsageZeiten = new HashMap<String, Map<String, Long>>();
    private Map<Integer, Long> stehendAnsageZeiten = new HashMap<Integer, Long>();
    private Map<Integer, Long> haltZeiten = new HashMap<Integer, Long>();
    private Map<String, Set<String>> einfahrtGemeldet = new HashMap<String, Set<String>>();
    private boolean einfahrten;
    private boolean anschluesse;
    private boolean verspaetungen;
    private boolean minutengenau;

    public AnsageManager(StellwerkFile config, boolean einfahrten, boolean anschluesse, boolean verspaetungen, boolean minutengenau) {
        this.config = config;
        this.einfahrten = einfahrten;
        this.anschluesse = anschluesse;
        this.verspaetungen = verspaetungen;
        this.minutengenau = minutengenau;
    }

    @Override
    public void bahnsteigSetup(String bahnsteig, Bahnhof bahnhof) {
    }

    @Override
    public void naechsterZug(String gleis, Bahnhof bahnhof, int zid, DataCache cache) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void zugEinfahrt(String gleis, Bahnhof bahnhof, int zid, DataCache cache) {
        if (!this.einfahrtGemeldet.containsKey(gleis) || !this.einfahrtGemeldet.get(gleis).contains(cache.getDetailCache().get((Object)Integer.valueOf((int)zid)).name)) {
            if (!this.einfahrtGemeldet.containsKey(gleis)) {
                this.einfahrtGemeldet.put(gleis, new HashSet());
            }
            this.einfahrtGemeldet.get(gleis).add(cache.getDetailCache().get((Object)Integer.valueOf((int)zid)).name);
        }
        if (this.einfahrten) {
            RewrittenDetails details = Rewriter.getInstance().rewrite(cache.getDetailCache().get(zid), bahnhof);
            List<PluginClient.ZugFahrplanZeile> plan = cache.getFahrplaene().get(zid);
            int startIndex = 0;
            for (int i = 0; i < plan.size(); ++i) {
                if (!plan.get((int)i).gleis.equals(gleis)) continue;
                startIndex = i + 1;
                break;
            }
            if (plan.get((int)(startIndex - 1)).flags.hasFlag('D') || Pattern.matches(Main.CONFIG.getIgnorePattern(), cache.getDetailCache().get((Object)Integer.valueOf((int)zid)).name)) {
                SoundPlayer.getInstance().addText(SoundPlayer.Priority.HIGH, Main.CONFIG.getAnsage("durchfahrt", details));
                SoundPlayer i = SoundPlayer.getInstance();
                synchronized (i) {
                    SoundPlayer.getInstance().notify();
                }
            }
            if (Pattern.matches(bahnhof.getEndeRegex(), cache.getDetailCache().get((Object)Integer.valueOf((int)zid)).nach) || Pattern.matches(bahnhof.getEndeRegex(), details.nach)) {
                long anschlussZeit;
                SoundPlayer.getInstance().addText(SoundPlayer.Priority.HIGH, Main.CONFIG.getAnsage("einfahrt-endend", details, plan.get(startIndex - 1)));
                SoundPlayer i = SoundPlayer.getInstance();
                synchronized (i) {
                    SoundPlayer.getInstance().notify();
                }
                if (this.anschluesse && (anschlussZeit = (plan.get((int)(startIndex - 1)).an - Main.client.getSimutime()) / 1000L + (long)(details.verspaetung * 60)) < 0L) {
                    anschlussZeit = 0L;
                }
            } else {
                String vias = "";
                if (details.rewritten) {
                    vias = details.vias;
                } else {
                    for (int i = startIndex; i < startIndex + 3; ++i) {
                        String viaBhf = null;
                        if (viaBhf == null && plan.size() > i) {
                            vias = vias + " - " + plan.get((int)i).gleis;
                        }
                        if (viaBhf == null || viaBhf.length() <= 0) continue;
                        vias = vias + " - " + viaBhf;
                    }
                    if (vias.length() > 0) {
                        vias = vias.substring(3);
                    }
                }
                if (Pattern.matches(bahnhof.getEndeRegex(), details.von) || details.von.equals(details.nach)) {
                    Main.client.haltGemeldet(zid, gleis);
                    if (cache.getDetailCache().get((Object)Integer.valueOf((int)zid)).amgleis) {
                        this.haltZeiten.put(zid, Main.client.getSimutime());
                    }
                    SoundPlayer.getInstance().addText(SoundPlayer.Priority.HIGH, Main.CONFIG.getAnsage("einfahrt-bereitstellung", details, plan.get(startIndex - 1), vias));
                } else {
                    SoundPlayer.getInstance().addText(SoundPlayer.Priority.HIGH, Main.CONFIG.getAnsage("einfahrt-normal", details, plan.get(startIndex - 1), vias));
                }
                SoundPlayer soundPlayer = SoundPlayer.getInstance();
                synchronized (soundPlayer) {
                    SoundPlayer.getInstance().notify();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void idleAction(DataCache cache) {
        if (this.verspaetungen) {
            for (String gleis : cache.getBelegung().keySet()) {
                Bahnhof bahnhof = null;
                for (Bahnhof bhf : this.config.getBahnhoefe()) {
                    if (!Pattern.matches(bhf.getGleiseRegex(), gleis)) continue;
                    bahnhof = bhf;
                    break;
                }
                if (bahnhof == null) {
                    throw new RuntimeException("Bahnhof not found");
                }
                long simutime = Main.client.getSimutime();
                List<ZugBelegung> planBelegung = cache.getBelegung().get(gleis);
                if (planBelegung == null) continue;
                Collections.sort(planBelegung, new ZugBelegung.DelayComparator());
                for (ZugBelegung zugBelegung : planBelegung) {
                    SoundPlayer soundPlayer;
                    RewrittenDetails details;
                    if (zugBelegung.zeile == null || zugBelegung.zug == null || Pattern.matches(Main.CONFIG.getIgnorePattern(), zugBelegung.zug.name)) continue;
                    if (!(zugBelegung.zeile.flags.hasFlag('D') || zugBelegung.zeile.gleis.equals(zugBelegung.zeile.plan) || (zugBelegung.zeile.an + (long)(zugBelegung.zug.verspaetung * 60000) <= simutime || (zugBelegung.zeile.an + (long)(zugBelegung.zug.verspaetung * 60000) - simutime) / 60000L > 15L) && (zugBelegung.zeile.ab + (long)(zugBelegung.zug.verspaetung * 60000) <= simutime || (zugBelegung.zeile.ab + (long)(zugBelegung.zug.verspaetung * 60000) - simutime) / 60000L > 15L) || this.gleiswechselAnsageZeiten.containsKey(gleis) && this.gleiswechselAnsageZeiten.get(gleis).containsKey(zugBelegung.zug.name) && simutime - this.gleiswechselAnsageZeiten.get(gleis).get(zugBelegung.zug.name) < 300000L)) {
                        details = Rewriter.getInstance().rewrite(zugBelegung.zug, bahnhof);
                        if (!this.gleiswechselAnsageZeiten.containsKey(gleis)) {
                            this.gleiswechselAnsageZeiten.put(gleis, new HashMap());
                        }
                        this.gleiswechselAnsageZeiten.get(gleis).put(details.name, simutime);
                        if (Pattern.matches(bahnhof.getEndeRegex(), details.nach) || details.nach.equals("")) {
                            if (zugBelegung.zug.verspaetung >= 5) {
                                SoundPlayer.getInstance().addText(SoundPlayer.Priority.HIGH, Main.CONFIG.getAnsage("gleiswechsel-endend-verspaetet", details, zugBelegung.zeile));
                            } else {
                                SoundPlayer.getInstance().addText(SoundPlayer.Priority.HIGH, Main.CONFIG.getAnsage("gleiswechsel-endend-normal", details, zugBelegung.zeile));
                            }
                        } else if (zugBelegung.zug.verspaetung >= 5) {
                            SoundPlayer.getInstance().addText(SoundPlayer.Priority.HIGH, Main.CONFIG.getAnsage("gleiswechsel-normal-verspaetet", details, zugBelegung.zeile));
                        } else {
                            SoundPlayer.getInstance().addText(SoundPlayer.Priority.HIGH, Main.CONFIG.getAnsage("gleiswechsel-normal-normal", details, zugBelegung.zeile));
                        }
                        soundPlayer = SoundPlayer.getInstance();
                        synchronized (soundPlayer) {
                            SoundPlayer.getInstance().notify();
                        }
                    }
                    if (!(zugBelegung.zeile.flags.hasFlag('D') || (zugBelegung.zeile.an + (long)(zugBelegung.zug.verspaetung * 60000) <= simutime || (zugBelegung.zeile.an - simutime) / 60000L > 15L) && (zugBelegung.zeile.ab + (long)(zugBelegung.zug.verspaetung * 60000) <= simutime || (zugBelegung.zeile.ab - simutime) / 60000L > 15L) || zugBelegung.zug.verspaetung < 5 || this.einfahrtGemeldet.containsKey(gleis) && this.einfahrtGemeldet.get(gleis).contains(zugBelegung.zug.name) || this.verspaetungsAnsageZeiten.containsKey(gleis) && this.verspaetungsAnsageZeiten.get(gleis).containsKey(zugBelegung.zug.name) && simutime - this.verspaetungsAnsageZeiten.get(gleis).get(zugBelegung.zug.name) < 300000L)) {
                        details = Rewriter.getInstance().rewrite(zugBelegung.zug, bahnhof);
                        if (!this.verspaetungsAnsageZeiten.containsKey(gleis)) {
                            this.verspaetungsAnsageZeiten.put(gleis, new HashMap());
                        }
                        this.verspaetungsAnsageZeiten.get(gleis).put(details.name, simutime);
                        details.gleis = gleis;
                        if (Pattern.matches(bahnhof.getEndeRegex(), details.nach) || details.nach.equals("")) {
                            SoundPlayer.getInstance().addText(SoundPlayer.Priority.LOW, Main.CONFIG.getAnsage("verspaetung-endend", details, zugBelegung.zeile));
                        } else {
                            SoundPlayer.getInstance().addText(SoundPlayer.Priority.LOW, Main.CONFIG.getAnsage("verspaetung-normal", details, zugBelegung.zeile));
                        }
                        soundPlayer = SoundPlayer.getInstance();
                        synchronized (soundPlayer) {
                            SoundPlayer.getInstance().notify();
                        }
                    }
                    if (zugBelegung.zeile.flags.hasFlag('D') || !zugBelegung.zug.amgleis || zugBelegung.zug.gleis == null || !this.einfahrtGemeldet.containsKey(gleis) || !this.einfahrtGemeldet.get(gleis).contains(zugBelegung.zug.name) || !this.haltZeiten.containsKey(zugBelegung.zug.zid) || simutime - this.haltZeiten.get(zugBelegung.zug.zid) < 180000L || this.stehendAnsageZeiten.containsKey(zugBelegung.zug.zid) && simutime - this.stehendAnsageZeiten.get(zugBelegung.zug.zid) < 300000L) continue;
                    details = Rewriter.getInstance().rewrite(zugBelegung.zug, bahnhof);
                    if (!details.rewritten || !Pattern.matches(bahnhof.getEndeRegex(), zugBelegung.zug.nach) && !Pattern.matches(bahnhof.getEndeRegex(), details.nach)) continue;
                    SoundPlayer.getInstance().addText(SoundPlayer.Priority.LOW, Main.CONFIG.getAnsage("stehend", details, zugBelegung.zeile, details.vias));
                    soundPlayer = SoundPlayer.getInstance();
                    synchronized (soundPlayer) {
                        SoundPlayer.getInstance().notify();
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void zugHalt(String gleis, Bahnhof bahnhof, int zid, DataCache cache) {
        if (this.anschluesse && !Pattern.matches(Main.CONFIG.getIgnorePattern(), cache.getDetailCache().get((Object)Integer.valueOf((int)zid)).name)) {
            try {
                cache = Main.client.getLastRunCache();
                StringBuilder ansage = new StringBuilder();
                RewrittenDetails details = Rewriter.getInstance().rewrite(cache.getDetailCache().get(zid), bahnhof);
                details.gleis = gleis;
                this.haltZeiten.put(zid, Main.client.getSimutime());
                if (details.nach == null || Pattern.matches(bahnhof.getEndeRegex(), details.nach)) {
                    ansage.append(Main.CONFIG.getAnsage("halt-endend", details, null, null, bahnhof.getName()));
                } else {
                    ansage.append(Main.CONFIG.getAnsage("halt-normal", details, null, null, bahnhof.getName()));
                }
                List<ZugBelegung> anschlussZuege = this.getAnschlusszuege(cache, bahnhof, gleis);
                if (!anschlussZuege.isEmpty()) {
                    ansage.append(" ");
                    ansage.append(Main.CONFIG.getAnsage("anschluesse", details));
                    for (ZugBelegung planzug : anschlussZuege) {
                        details = Rewriter.getInstance().rewrite(cache.getDetailCache().get(planzug.zug.zid), bahnhof);
                        ansage.append(" ");
                        if (planzug.zug.verspaetung >= 5) {
                            ansage.append(Main.CONFIG.getAnsage("anschluss-verspaetet", details, planzug.zeile));
                            continue;
                        }
                        ansage.append(Main.CONFIG.getAnsage("anschluss-normal", details, planzug.zeile));
                    }
                }
                SoundPlayer.getInstance().addText(SoundPlayer.Priority.MEDIUM, ansage.toString());
                SoundPlayer soundPlayer = SoundPlayer.getInstance();
                synchronized (soundPlayer) {
                    SoundPlayer.getInstance().notify();
                }
            }
            catch (Exception ex) {
                Logger.getAnonymousLogger().log(Level.WARNING, "AnschlussAnsage", ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void zugAbfahrt(String gleis, Bahnhof bahnhof, int zid, DataCache cache) {
        block8: {
            if (this.anschluesse && !Pattern.matches(Main.CONFIG.getIgnorePattern(), cache.getDetailCache().get((Object)Integer.valueOf((int)zid)).name)) {
                try {
                    cache = Main.client.getLastRunCache();
                    if (this.haltZeiten.containsKey(zid)) {
                        this.haltZeiten.remove(zid);
                    }
                    if (cache.getDetailCache().get(zid) == null || !Util.isFernzug(cache.getDetailCache().get((Object)Integer.valueOf((int)zid)).name)) break block8;
                    RewrittenDetails details = Rewriter.getInstance().rewrite(cache.getDetailCache().get(zid), bahnhof);
                    if (details.nach == null && Pattern.matches(bahnhof.getEndeRegex(), details.nach)) {
                        return;
                    }
                    SoundPlayer.getInstance().addText(SoundPlayer.Priority.MEDIUM, Main.CONFIG.getAnsage("abfahrt", details));
                    SoundPlayer soundPlayer = SoundPlayer.getInstance();
                    synchronized (soundPlayer) {
                        SoundPlayer.getInstance().notify();
                    }
                }
                catch (Exception ex) {
                    Logger.getAnonymousLogger().log(Level.WARNING, "AbfahrtAnsage", ex);
                }
            }
        }
    }

    private List<ZugBelegung> getAnschlusszuege(DataCache cache, Bahnhof bahnhof, String gleis) {
        List<ZugBelegung> ret = new ArrayList<ZugBelegung>();
        for (String nachbargleis : cache.getBelegung().keySet()) {
            if (!Pattern.matches(bahnhof.getGleiseRegex(), nachbargleis) || nachbargleis.equals(gleis)) continue;
            List<ZugBelegung> zuege = cache.getBelegung().get(nachbargleis);
            Collections.sort(zuege, new ZugBelegung.DelayComparator());
            for (ZugBelegung planzug : zuege) {
                if (Pattern.matches(Main.CONFIG.getIgnorePattern(), planzug.zug.name) || planzug.zeile.flags.hasFlag('D') || planzug.zeile.ab <= 0L || planzug.zeile.ab > Main.client.getSimutime() + 900000L && planzug.zeile.ab + (long)(planzug.zug.verspaetung * 60000) > Main.client.getSimutime() + 900000L || Pattern.matches(bahnhof.getEndeRegex(), planzug.zug.nach)) continue;
                ret.add(planzug);
            }
        }
        Collections.sort(ret, new ZugBelegung.DelayComparator());
        int maxAnschluesse = Math.max(1, 5 - SoundPlayer.getInstance().getQueueLength());
        if (ret.size() > maxAnschluesse) {
            ret = ret.subList(0, maxAnschluesse - 1);
        }
        return ret;
    }

    @Override
    public void keinZug(String gleis) {
    }
}

