/*
 * Decompiled with CFR 0.152.
 */
package marytts.language.de.preprocess;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import marytts.language.de.preprocess.ExpansionPattern;
import marytts.util.MaryUtils;
import marytts.util.dom.MaryDomUtils;
import org.apache.log4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class NetEP
extends ExpansionPattern {
    private final String[] _knownTypes = new String[]{"net", "net:email", "net:uri"};
    private final List<String> knownTypes = Arrays.asList(this._knownTypes);
    protected final String aText = "[A-Za-z0-9\\!\\#\\$\\%\\&\\'\\*\\+\\-\\/\\=\\?\\^\\_\\`\\{\\|\\}\\~]+";
    protected final String dotAtomText = "(?:[A-Za-z0-9\\!\\#\\$\\%\\&\\'\\*\\+\\-\\/\\=\\?\\^\\_\\`\\{\\|\\}\\~]+(?:\\.[A-Za-z0-9\\!\\#\\$\\%\\&\\'\\*\\+\\-\\/\\=\\?\\^\\_\\`\\{\\|\\}\\~]+)*)";
    protected final String sNetEmail = "(?:((?:[A-Za-z0-9\\!\\#\\$\\%\\&\\'\\*\\+\\-\\/\\=\\?\\^\\_\\`\\{\\|\\}\\~]+(?:\\.[A-Za-z0-9\\!\\#\\$\\%\\&\\'\\*\\+\\-\\/\\=\\?\\^\\_\\`\\{\\|\\}\\~]+)*))\\@((?:[A-Za-z0-9\\!\\#\\$\\%\\&\\'\\*\\+\\-\\/\\=\\?\\^\\_\\`\\{\\|\\}\\~]+(?:\\.[A-Za-z0-9\\!\\#\\$\\%\\&\\'\\*\\+\\-\\/\\=\\?\\^\\_\\`\\{\\|\\}\\~]+)*)))";
    protected final String domainSuffix = "(?:com|edu|net|info|biz|org|de|eu|uk|ie|fr|au|jp|at|ch|ws|tv|cc)";
    protected final String domain = "(?:(?:[A-Za-z0-9\\-]+\\.)+(?:com|edu|net|info|biz|org|de|eu|uk|ie|fr|au|jp|at|ch|ws|tv|cc))";
    protected final String path = "(?:(?:/~?[A-Za-z0-9\\-\\.\\_]+)+/?)";
    protected final String sNetUri = "(?:(?:(?:http|ftp)://)?((?:(?:[A-Za-z0-9\\-]+\\.)+(?:com|edu|net|info|biz|org|de|eu|uk|ie|fr|au|jp|at|ch|ws|tv|cc)))((?:(?:/~?[A-Za-z0-9\\-\\.\\_]+)+/?))?)";
    protected final Pattern reNetEmail = Pattern.compile("(?:((?:[A-Za-z0-9\\!\\#\\$\\%\\&\\'\\*\\+\\-\\/\\=\\?\\^\\_\\`\\{\\|\\}\\~]+(?:\\.[A-Za-z0-9\\!\\#\\$\\%\\&\\'\\*\\+\\-\\/\\=\\?\\^\\_\\`\\{\\|\\}\\~]+)*))\\@((?:[A-Za-z0-9\\!\\#\\$\\%\\&\\'\\*\\+\\-\\/\\=\\?\\^\\_\\`\\{\\|\\}\\~]+(?:\\.[A-Za-z0-9\\!\\#\\$\\%\\&\\'\\*\\+\\-\\/\\=\\?\\^\\_\\`\\{\\|\\}\\~]+)*)))");
    protected final Pattern reNetUri = Pattern.compile("(?:(?:(?:http|ftp)://)?((?:(?:[A-Za-z0-9\\-]+\\.)+(?:com|edu|net|info|biz|org|de|eu|uk|ie|fr|au|jp|at|ch|ws|tv|cc)))((?:(?:/~?[A-Za-z0-9\\-\\.\\_]+)+/?))?)");
    private final Pattern reMatchingChars = null;
    private Logger logger = MaryUtils.getLogger((String)"NetEP");

    @Override
    public List<String> knownTypes() {
        return this.knownTypes;
    }

    @Override
    public Pattern reMatchingChars() {
        return this.reMatchingChars;
    }

    @Override
    protected boolean isCandidate(Element t) {
        String s = MaryDomUtils.tokenText((Element)t);
        return s.indexOf(64) != -1 || s.indexOf(46) != -1 || s.indexOf(47) != -1 || s.indexOf(58) != -1 || s.equals("http") || s.equals("ftp") || s.equals("mailto");
    }

    @Override
    protected boolean doesFullExpansion() {
        return false;
    }

    @Override
    protected int canDealWith(String s, int type) {
        return this.match(s, type);
    }

    @Override
    protected int match(String s, int type) {
        switch (type) {
            case 0: {
                if (this.matchNetEmail(s)) {
                    return 1;
                }
                if (!this.matchNetUri(s)) break;
                return 2;
            }
            case 1: {
                if (!this.matchNetEmail(s)) break;
                return 1;
            }
            case 2: {
                if (!this.matchNetUri(s)) break;
                return 2;
            }
        }
        return -1;
    }

    @Override
    protected List<Element> expand(List<Element> tokens, String s, int type) {
        if (tokens == null) {
            throw new NullPointerException("Received null argument");
        }
        if (tokens.isEmpty()) {
            throw new IllegalArgumentException("Received empty list");
        }
        Element firstOld = tokens.get(0);
        Document doc = firstOld.getOwnerDocument();
        List<Element> expanded = null;
        switch (type) {
            case 1: {
                expanded = this.expandNetEmail(doc, s);
                break;
            }
            case 2: {
                expanded = this.expandNetUri(doc, s);
            }
        }
        this.replaceTokens(tokens, expanded);
        return expanded;
    }

    private boolean matchNetEmail(String s) {
        return this.reNetEmail.matcher(s).matches();
    }

    private boolean matchNetUri(String s) {
        return this.reNetUri.matcher(s).matches();
    }

    protected List<Element> expandNetEmail(Document doc, String s) {
        ArrayList<Element> exp = new ArrayList<Element>();
        Matcher reMatcher = this.reNetEmail.matcher(s);
        if (!reMatcher.find()) {
            return null;
        }
        String localPart = reMatcher.group(1);
        String localPartExpanded = abbrev.ruleExpandAbbrev(localPart, true);
        exp.addAll(this.makeNewTokens(doc, localPartExpanded, true, localPart, true));
        exp.add(MaryDomUtils.createBoundary((Document)doc));
        exp.addAll(this.makeNewTokens(doc, "at['?{t]", true, "@", true));
        String domain = reMatcher.group(2);
        exp.addAll(this.expandDomain(doc, domain));
        return exp;
    }

    protected List<Element> expandNetUri(Document doc, String s) {
        ArrayList<Element> exp = new ArrayList<Element>();
        Matcher reMatcher = this.reNetUri.matcher(s);
        if (!reMatcher.find()) {
            return null;
        }
        String domain = reMatcher.group(1);
        exp.addAll(this.expandDomain(doc, domain));
        String path = reMatcher.group(2);
        if (path != null && path.length() > 0) {
            String pathExpanded = abbrev.ruleExpandAbbrev(path, true);
            exp.addAll(this.makeNewTokens(doc, pathExpanded, true, path, true));
            exp.add(MaryDomUtils.createBoundary((Document)doc));
        }
        return exp;
    }

    private List<Element> expandDomain(Document doc, String domain) {
        String toExpand;
        this.logger.debug((Object)("Expanding domain `" + domain + "'"));
        ArrayList<Element> exp = new ArrayList<Element>();
        String domainSuffix = null;
        if (domain.endsWith(".com")) {
            toExpand = domain.substring(0, domain.length() - 4);
            domainSuffix = " dot['dOt] com['kOm]";
        } else if (domain.lastIndexOf(".") == domain.length() - 3) {
            toExpand = domain.substring(0, domain.length() - 3);
            this.logger.debug((Object)("toExpand = `" + toExpand + "'"));
            domainSuffix = " " + domain.substring(domain.length() - 2, domain.length() - 1) + " " + domain.substring(domain.length() - 1);
            this.logger.debug((Object)("domainSuffix = `" + domainSuffix + "'"));
        } else {
            toExpand = domain;
        }
        String domainExpanded = toExpand.replaceAll("\\.", " ");
        this.logger.debug((Object)("domainExpanded = `" + domainExpanded + "'"));
        if (domainSuffix != null) {
            domainExpanded = domainExpanded + domainSuffix;
        }
        this.logger.debug((Object)("domainExpanded with suffix = `" + domainExpanded + "'"));
        exp.addAll(this.makeNewTokens(doc, domainExpanded, true, domain, true));
        exp.add(MaryDomUtils.createBoundary((Document)doc));
        return exp;
    }
}

