/*
 * Decompiled with CFR 0.152.
 */
package marytts.language.de.preprocess;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import marytts.language.de.preprocess.ExpansionPattern;
import marytts.util.MaryUtils;
import marytts.util.dom.MaryDomUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class CurrencyEP
extends ExpansionPattern {
    private final String[] _knownTypes = new String[]{"currency"};
    private final List<String> knownTypes = Arrays.asList(this._knownTypes);
    private final String[] _currencySymbolNames = new String[]{"DM", "Mark", new Character('\u20ac').toString(), "Euro", "$", "Dollar", "FF", "Francs['frO~]", new Character('\u00a5').toString(), "Yen['jEn]", new Character('\u00a3').toString(), "Pfund", "sFr.", "Franken", "Kr.", "Kronen", "USD", "U S Dollar", "ATS", "Schilling", "BEF", "belgische Francs['frO~]", "GBP", "britische Pfund", "DKK", "daenische Kronen", "NLG", "Gulden", "EUR", "Euro", "Euro", "Euro", "FRF", "Francs['frO~]", "DEM", "Mark", "GRD", "Drachmen", "IEP", "irische Pfund", "ITL", "Lire", "JPY", "Yen['jEn]", "LUF", "luxemburgische Francs['frO~]", "PTE", "Escudo[Es-'ku:-do:]", "RUB", "Rubel", "ESP", "Peseten", "SEK", "schwedische Kronen", "CHF", "Franken"};
    private final Map<String, String> currencySymbolNames = MaryUtils.arrayToMap((String[])this._currencySymbolNames);
    private final String[] _currencySymbolNamesSingular = new String[]{"DM", "eine Mark", new Character('\u20ac').toString(), "ein Euro", "$", "ein Dollar", "FF", "ein Francs['frO~]", new Character('\u00a5').toString(), "ein Yen['jEn]", new Character('\u00a3').toString(), "ein Pfund", "sFr.", "ein Franken", "Kr.", "eine Krone", "USD", "ein U S Dollar", "ATS", "ein Schilling", "BEF", "ein belgischer Francs['frO~]", "GBP", "ein britisches Pfund", "DKK", "eine daenische Krone", "NLG", "ein Gulden", "EUR", "ein Euro", "FRF", "ein Francs['frO~]", "DEM", "eine Mark", "GRD", "eine Drachme", "IEP", "ein irisches Pfund", "ITL", "eine Lire", "JPY", "ein Yen['jEn]", "LUF", "ein luxemburgischer Francs['frO~]", "PTE", "ein Escudo[Es-'ku:-do:]", "RUB", "ein Rubel", "ESP", "eine Pesete", "SEK", "eine schwedische Krone", "CHF", "ein Franken"};
    private final Map<String, String> currencySymbolNamesSingular = MaryUtils.arrayToMap((String[])this._currencySymbolNamesSingular);
    protected final String sCurrencySymbol = this.getCurrencySymbols();
    protected final String sCurrencyAmount = "(?:(?:-?[1-9][0-9]{0,8}|0)(?:[,.](?:-|[0-9][0-9]))?)";
    protected final String sCurrencyAmountSubstructure = "(?:((?:-?[1-9][0-9]{0,8}|0))(?:[,.](-|[0-9][0-9]))?)";
    protected final Pattern reCurrencyLeading = Pattern.compile("(" + this.sCurrencySymbol + ")(" + "(?:(?:-?[1-9][0-9]{0,8}|0)(?:[,.](?:-|[0-9][0-9]))?)" + ")");
    protected final Pattern reCurrencyTrailing = Pattern.compile("((?:(?:-?[1-9][0-9]{0,8}|0)(?:[,.](?:-|[0-9][0-9]))?))(" + this.sCurrencySymbol + ")");
    protected final Pattern reCurrencyAmountSubstructure = Pattern.compile("(?:((?:-?[1-9][0-9]{0,8}|0))(?:[,.](-|[0-9][0-9]))?)");
    private final Pattern reMatchingChars = null;

    @Override
    public List<String> knownTypes() {
        return this.knownTypes;
    }

    @Override
    public Pattern reMatchingChars() {
        return this.reMatchingChars;
    }

    private String getCurrencySymbols() {
        StringBuilder _sCurrencySymbol = new StringBuilder("(?:\\$");
        for (int i = 0; i < this._currencySymbolNames.length; i += 2) {
            if (this._currencySymbolNames[i].equals("$")) continue;
            _sCurrencySymbol.append("|" + this._currencySymbolNames[i]);
        }
        _sCurrencySymbol.append(")");
        return _sCurrencySymbol.toString();
    }

    @Override
    protected boolean isCandidate(Element t) {
        String s = MaryDomUtils.tokenText((Element)t);
        return s.length() <= 4 || number.isCandidate(t) || this.matchCurrency(s);
    }

    @Override
    protected int canDealWith(String s, int type) {
        return this.match(s, type);
    }

    @Override
    protected int match(String s, int type) {
        switch (type) {
            case 0: {
                if (!this.matchCurrency(s)) break;
                return 0;
            }
        }
        return -1;
    }

    @Override
    protected List<Element> expand(List<Element> tokens, String s, int type) {
        if (tokens == null) {
            throw new NullPointerException("Received null argument");
        }
        if (tokens.isEmpty()) {
            throw new IllegalArgumentException("Received empty list");
        }
        Document doc = tokens.get(0).getOwnerDocument();
        List<Element> expanded = null;
        switch (type) {
            case 0: {
                expanded = this.expandCurrency(doc, s);
            }
        }
        this.replaceTokens(tokens, expanded);
        return expanded;
    }

    private boolean matchCurrency(String s) {
        return this.reCurrencyLeading.matcher(s).matches() || this.reCurrencyTrailing.matcher(s).matches();
    }

    protected List<Element> expandCurrency(Document doc, String s) {
        ArrayList<Element> exp = new ArrayList<Element>();
        StringBuilder sb = new StringBuilder();
        String currency = null;
        String amount = null;
        Matcher reMatcher = this.reCurrencyLeading.matcher(s);
        if (reMatcher.find()) {
            currency = reMatcher.group(1);
            amount = reMatcher.group(2);
        } else {
            reMatcher = this.reCurrencyTrailing.matcher(s);
            if (!reMatcher.find()) {
                return null;
            }
            amount = reMatcher.group(1);
            currency = reMatcher.group(2);
        }
        reMatcher = this.reCurrencyAmountSubstructure.matcher(amount);
        reMatcher.find();
        String wholes = reMatcher.group(1);
        if (wholes.equals("1")) {
            String singularExpansion = this.currencySymbolNamesSingular.get(currency);
            sb.append(singularExpansion);
        } else {
            sb.append(number.expandInteger(wholes));
            sb.append(" ");
            String currencyName = this.currencySymbolNames.get(currency);
            sb.append(currencyName);
        }
        String cents = reMatcher.group(2);
        if (cents != null && cents.length() > 0 && !cents.equals("-")) {
            sb.append(" ");
            sb.append(number.expandInteger(cents));
        }
        exp.addAll(this.makeNewTokens(doc, sb.toString(), true, s));
        return exp;
    }
}

