/*
 * Decompiled with CFR 0.152.
 */
package marytts.language.de;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeMap;
import marytts.datatypes.MaryData;
import marytts.datatypes.MaryDataType;
import marytts.exceptions.MaryConfigurationException;
import marytts.fst.FSTLookup;
import marytts.language.de.phonemiser.Inflection;
import marytts.language.de.phonemiser.PhonemiseDenglish;
import marytts.language.de.phonemiser.Result;
import marytts.modules.synthesis.PAConverter;
import marytts.server.MaryProperties;
import marytts.util.MaryUtils;
import marytts.util.dom.MaryDomUtils;
import org.apache.commons.io.FileUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.traversal.NodeIterator;

public class JPhonemiser
extends marytts.modules.JPhonemiser {
    private Inflection inflection;
    private FSTLookup usEnglishLexicon = null;
    private String logUnknownFileName = null;
    private Map<String, Integer> unknown2Frequency = null;
    private String logEnglishFileName = null;
    private Map<String, Integer> english2Frequency = null;
    private PhonemiseDenglish phonemiseDenglish;

    public JPhonemiser() throws IOException, MaryConfigurationException {
        super("JPhonemiser_de", MaryDataType.PARTSOFSPEECH, MaryDataType.PHONEMES, "de.allophoneset", "de.userdict", "de.lexicon", "de.lettertosound");
    }

    public void startup() throws Exception {
        InputStream usLexStream;
        super.startup();
        this.phonemiseDenglish = new PhonemiseDenglish(this);
        this.inflection = new Inflection();
        if (MaryProperties.getBoolean((String)"de.phonemiser.logunknown")) {
            String logBasepath = MaryProperties.maryBase() + File.separator + "log" + File.separator;
            File logDir = new File(logBasepath);
            try {
                if (!logDir.isDirectory()) {
                    this.logger.info((Object)("Creating log directory " + logDir.getCanonicalPath()));
                    FileUtils.forceMkdir((File)logDir);
                }
                this.logUnknownFileName = MaryProperties.getFilename((String)"de.phonemiser.logunknown.filename", (String)(logBasepath + "de_unknown.txt"));
                this.unknown2Frequency = new HashMap<String, Integer>();
                this.logEnglishFileName = MaryProperties.getFilename((String)"de.phonemiser.logenglish.filename", (String)(logBasepath + "de_english-words.txt"));
                this.english2Frequency = new HashMap<String, Integer>();
            }
            catch (IOException e) {
                this.logger.info((Object)("Could not create log directory " + logDir.getCanonicalPath() + " Logging disabled!"), (Throwable)e);
            }
        }
        if (MaryProperties.getBoolean((String)"de.phonemiser.useenglish") && (usLexStream = MaryProperties.getStream((String)"en_US.lexicon")) != null) {
            try {
                this.usEnglishLexicon = new FSTLookup(usLexStream, MaryProperties.getProperty((String)"en_US.lexicon"));
            }
            catch (Exception e) {
                this.logger.info((Object)("Cannot load English lexicon '" + MaryProperties.getProperty((String)"en_US.lexicon") + "'"), (Throwable)e);
            }
        }
    }

    public void shutdown() {
        if (this.logUnknownFileName != null || this.logEnglishFileName != null) {
            try {
                PrintWriter logUnknown = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(this.logUnknownFileName), "UTF-8"));
                Set<String> unknownWords = this.unknown2Frequency.keySet();
                TreeMap freq2Unknown = new TreeMap();
                for (String nextUnknown : unknownWords) {
                    List<String> unknowns;
                    int nextFreq = this.unknown2Frequency.get(nextUnknown);
                    if (freq2Unknown.containsKey(nextFreq)) {
                        unknowns = (List)freq2Unknown.get(nextFreq);
                        unknowns.add(nextUnknown);
                        continue;
                    }
                    unknowns = new ArrayList<String>();
                    unknowns.add(nextUnknown);
                    freq2Unknown.put(nextFreq, unknowns);
                }
                Iterator<String> i$ = freq2Unknown.keySet().iterator();
                while (i$.hasNext()) {
                    int nextFreq = (Integer)((Object)i$.next());
                    List unknowns = (List)freq2Unknown.get(nextFreq);
                    for (int i = 0; i < unknowns.size(); ++i) {
                        String unknownWord = (String)unknowns.get(i);
                        logUnknown.println(nextFreq + " " + unknownWord);
                    }
                }
                logUnknown.flush();
                logUnknown.close();
                PrintWriter logEnglish = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(this.logEnglishFileName), "UTF-8"));
                TreeMap freq2English = new TreeMap();
                for (String nextEnglish : this.english2Frequency.keySet()) {
                    List<String> englishWords;
                    int nextFreq = this.english2Frequency.get(nextEnglish);
                    if (freq2English.containsKey(nextFreq)) {
                        englishWords = (List)freq2English.get(nextFreq);
                        englishWords.add(nextEnglish);
                        continue;
                    }
                    englishWords = new ArrayList<String>();
                    englishWords.add(nextEnglish);
                    freq2English.put(nextFreq, englishWords);
                }
                Iterator<String> i$2 = freq2English.keySet().iterator();
                while (i$2.hasNext()) {
                    int nextFreq = (Integer)((Object)i$2.next());
                    List englishWords = (List)freq2English.get(nextFreq);
                    for (int i = 0; i < englishWords.size(); ++i) {
                        logEnglish.println(nextFreq + " " + (String)englishWords.get(i));
                    }
                }
                logEnglish.flush();
                logEnglish.close();
            }
            catch (Exception e) {
                this.logger.info((Object)"Error printing log files for english and unknown words", (Throwable)e);
            }
        }
    }

    public MaryData process(MaryData d) throws Exception {
        Document doc = d.getDocument();
        this.inflection.determineEndings(doc);
        NodeIterator it = MaryDomUtils.createNodeIterator((Document)doc, (Node)doc, (String[])new String[]{"t"});
        Element t = null;
        while ((t = (Element)it.nextNode()) != null) {
            if (t.hasAttribute("ph") && t.getAttribute("ph").indexOf(42) == -1) continue;
            String text = t.hasAttribute("sounds_like") ? t.getAttribute("sounds_like") : MaryDomUtils.tokenText((Element)t);
            String pos = null;
            if (t.hasAttribute("pos")) {
                pos = t.getAttribute("pos");
            }
            boolean isEnglish = false;
            if (t.hasAttribute("xml:lang") && MaryUtils.subsumes((Locale)Locale.ENGLISH, (Locale)MaryUtils.string2locale((String)t.getAttribute("xml:lang")))) {
                isEnglish = true;
            }
            if (text == null || text.equals("")) continue;
            StringBuilder ph = new StringBuilder();
            String g2pMethod = null;
            StringTokenizer st = new StringTokenizer(text, " -");
            while (st.hasMoreTokens()) {
                String graph = st.nextToken();
                StringBuilder helper = new StringBuilder();
                String phon = null;
                if (isEnglish && this.usEnglishLexicon != null && (phon = this.phonemiseEn(graph)) != null) {
                    helper.append("foreign:en");
                }
                if (phon == null) {
                    phon = this.phonemise(graph, pos, helper);
                }
                if (ph.length() == 0) {
                    g2pMethod = helper.toString();
                    ph.append(phon);
                    continue;
                }
                ph.append(" - ");
                ph.append(phon.replace('\'', ','));
            }
            if (ph == null || ph.length() <= 0) continue;
            this.setPh(t, ph.toString());
            t.setAttribute("g2p_method", g2pMethod);
        }
        MaryData result = new MaryData(this.outputType(), d.getLocale());
        result.setDocument(doc);
        return result;
    }

    public String phonemise(String text, String pos, StringBuilder g2pMethod) {
        String englishTranscription;
        String result = this.userdictLookup(text, pos);
        if (result != null) {
            g2pMethod.append("userdict");
            return result;
        }
        result = this.lexiconLookup(text, pos);
        if (result != null) {
            g2pMethod.append("lexicon");
            return result;
        }
        String normalised = MaryUtils.normaliseUnicodeLetters((String)text, (Locale)Locale.GERMAN);
        if (!normalised.equals(text)) {
            result = this.userdictLookup(normalised, pos);
            if (result != null) {
                g2pMethod.append("userdict");
                return result;
            }
            result = this.lexiconLookup(normalised, pos);
            if (result != null) {
                g2pMethod.append("lexicon");
                return result;
            }
        }
        if (this.usEnglishLexicon != null && (englishTranscription = this.phonemiseEn(text)) != null) {
            g2pMethod.append("foreign:en");
            this.logger.debug((Object)(text + " is English"));
            if (this.logEnglishFileName != null) {
                String englishText = text.trim();
                if (this.english2Frequency.containsKey(englishText)) {
                    int textFreq = this.english2Frequency.get(englishText);
                    this.english2Frequency.put(englishText, ++textFreq);
                } else {
                    this.english2Frequency.put(englishText, 1);
                }
            }
            return englishTranscription;
        }
        Result resultingWord = this.phonemiseDenglish.processWord(text, this.usEnglishLexicon != null);
        result = resultingWord.getTranscription();
        boolean usedOtherLanguageToPhonemise = resultingWord.isUsedOtherLanguageToPhonemise();
        if (result != null) {
            result = this.allophoneSet.splitAllophoneString(result);
            if (usedOtherLanguageToPhonemise) {
                g2pMethod.append("phonemiseDenglish");
                return result;
            }
            g2pMethod.append("compound");
            return result;
        }
        String phones = this.lts.predictPronunciation(normalised);
        result = this.lts.syllabify(phones);
        if (result != null) {
            if (this.logUnknownFileName != null) {
                String unknownText = text.trim();
                if (this.unknown2Frequency.containsKey(unknownText)) {
                    int textFreq = this.unknown2Frequency.get(unknownText);
                    this.unknown2Frequency.put(unknownText, ++textFreq);
                } else {
                    this.unknown2Frequency.put(unknownText, new Integer(1));
                }
            }
            g2pMethod.append("rules");
            return result;
        }
        return null;
    }

    public String phonemiseEn(String text) {
        assert (this.usEnglishLexicon != null);
        String normalisedEn = MaryUtils.normaliseUnicodeLetters((String)text, (Locale)Locale.US);
        normalisedEn = normalisedEn.toLowerCase();
        String[] transcriptions = this.usEnglishLexicon.lookup(normalisedEn);
        assert (transcriptions != null);
        if (transcriptions.length == 0) {
            return null;
        }
        String usSampa = transcriptions[0];
        String deSampa = PAConverter.sampaEnString2sampaDeString((String)usSampa);
        return deSampa;
    }
}

