/*
 * Copyright 2011 Matthias Butz <mtz@mtz.cc>. All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without modification, are
 * permitted provided that the following conditions are met:
 *
 *   1. Redistributions of source code must retain the above copyright notice, this list of
 *      conditions and the following disclaimer.
 *
 *   2. Redistributions in binary form must reproduce the above copyright notice, this list
 *      of conditions and the following disclaimer in the documentation and/or other materials
 *      provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY MATTHIAS BUTZ ''AS IS'' AND ANY EXPRESS OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
 * FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL MATTHIAS BUTZ OR
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON
 * ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF
 * ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/

/*
 * Zza.java
 *
 * Created on 27.02.2011, 23:26:25
 */

package cc.mtz.sts.zza.ui;

/**
 *
 * @author Matze
 */
public class Zza extends javax.swing.JFrame {

    /** Creates new form Zza */
    public Zza() {
        //setUndecorated(true);
        initComponents();
    }

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {
        bindingGroup = new org.jdesktop.beansbinding.BindingGroup();

        jPanel1 = new javax.swing.JPanel();
        lblZugZiel = new javax.swing.JLabel();
        lblGleis = new javax.swing.JLabel();
        lblAbfahrt = new javax.swing.JLabel();
        lblZug = new javax.swing.JLabel();
        lblVias = new javax.swing.JLabel();
        jPanel2 = new javax.swing.JPanel();
        lblInfoText = new MarqueeLabel();

        setDefaultCloseOperation(javax.swing.WindowConstants.EXIT_ON_CLOSE);
        setTitle("Zugzielanzeiger");
        setAlwaysOnTop(true);
        setBackground(new java.awt.Color(102, 102, 255));
        getContentPane().setLayout(new org.netbeans.lib.awtextra.AbsoluteLayout());

        jPanel1.setBackground(new java.awt.Color(34, 35, 117));

        org.jdesktop.beansbinding.Binding binding = org.jdesktop.beansbinding.Bindings.createAutoBinding(org.jdesktop.beansbinding.AutoBinding.UpdateStrategy.READ_WRITE, this, org.jdesktop.beansbinding.ELProperty.create("${preferredSize}"), jPanel1, org.jdesktop.beansbinding.BeanProperty.create("preferredSize"));
        bindingGroup.addBinding(binding);

        jPanel1.setLayout(new org.netbeans.lib.awtextra.AbsoluteLayout());

        lblZugZiel.setFont(new java.awt.Font("Tahoma", 1, 24)); // NOI18N
        lblZugZiel.setForeground(new java.awt.Color(255, 255, 255));
        lblZugZiel.setText("Zugziel");
        jPanel1.add(lblZugZiel, new org.netbeans.lib.awtextra.AbsoluteConstraints(86, 63, 317, -1));

        lblGleis.setFont(new java.awt.Font("Tahoma", 0, 48));
        lblGleis.setForeground(new java.awt.Color(255, 255, 255));
        lblGleis.setHorizontalAlignment(javax.swing.SwingConstants.RIGHT);
        lblGleis.setText("XX");
        lblGleis.setHorizontalTextPosition(javax.swing.SwingConstants.RIGHT);
        jPanel1.add(lblGleis, new org.netbeans.lib.awtextra.AbsoluteConstraints(410, 10, -1, 49));

        lblAbfahrt.setFont(new java.awt.Font("Tahoma", 0, 18));
        lblAbfahrt.setForeground(new java.awt.Color(255, 255, 255));
        lblAbfahrt.setText("Abfahrt");
        jPanel1.add(lblAbfahrt, new org.netbeans.lib.awtextra.AbsoluteConstraints(10, 11, -1, -1));

        lblZug.setFont(new java.awt.Font("Tahoma", 0, 12));
        lblZug.setForeground(new java.awt.Color(255, 255, 255));
        lblZug.setText("Zug");
        jPanel1.add(lblZug, new org.netbeans.lib.awtextra.AbsoluteConstraints(10, 37, -1, -1));

        lblVias.setFont(new java.awt.Font("Tahoma", 0, 12));
        lblVias.setForeground(new java.awt.Color(255, 255, 255));
        lblVias.setText("Vias");
        jPanel1.add(lblVias, new org.netbeans.lib.awtextra.AbsoluteConstraints(86, 37, -1, -1));

        jPanel2.setBackground(new java.awt.Color(255, 255, 255));

        lblInfoText.setBackground(new java.awt.Color(255, 255, 255));
        lblInfoText.setText("Infotext");

        javax.swing.GroupLayout jPanel2Layout = new javax.swing.GroupLayout(jPanel2);
        jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(
            jPanel2Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addComponent(lblInfoText, javax.swing.GroupLayout.Alignment.TRAILING, javax.swing.GroupLayout.DEFAULT_SIZE, 317, Short.MAX_VALUE)
        );
        jPanel2Layout.setVerticalGroup(
            jPanel2Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanel2Layout.createSequentialGroup()
                .addComponent(lblInfoText)
                .addContainerGap(1, Short.MAX_VALUE))
        );

        jPanel1.add(jPanel2, new org.netbeans.lib.awtextra.AbsoluteConstraints(86, 11, -1, 15));

        getContentPane().add(jPanel1, new org.netbeans.lib.awtextra.AbsoluteConstraints(0, 0, 480, 123));

        bindingGroup.bind();

        java.awt.Dimension screenSize = java.awt.Toolkit.getDefaultToolkit().getScreenSize();
        setBounds((screenSize.width-493)/2, (screenSize.height-157)/2, 493, 157);
    }// </editor-fold>//GEN-END:initComponents


    public void update(final String zug, final String zugZiel, final String abfahrt, final String vias, final String infoText) {
        java.awt.EventQueue.invokeLater(new Runnable() {
            public void run() {
                /*if (zugZiel.length() > 0) {
                    if (!isVisible())
                        setVisible(true);
                } else {
                    setVisible(false);
                }*/
                lblZugZiel.setText(zugZiel);
                lblAbfahrt.setText(abfahrt);
                lblInfoText.setText(infoText);
                jPanel2.setVisible(!infoText.isEmpty());
                lblVias.setText(vias);
                lblZug.setText(zug);
                invalidate();
            }
        });
    }

    public void setGleis(final String gleis) {
        java.awt.EventQueue.invokeLater(new Runnable() {
            public void run() {
                lblGleis.setText(gleis);
                invalidate();
            }
        });
    }

    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JPanel jPanel1;
    private javax.swing.JPanel jPanel2;
    private javax.swing.JLabel lblAbfahrt;
    private javax.swing.JLabel lblGleis;
    private javax.swing.JLabel lblInfoText;
    private javax.swing.JLabel lblVias;
    private javax.swing.JLabel lblZug;
    private javax.swing.JLabel lblZugZiel;
    private org.jdesktop.beansbinding.BindingGroup bindingGroup;
    // End of variables declaration//GEN-END:variables

}
