/*
 * Copyright 2011 Matthias Butz <mtz@mtz.cc>. All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without modification, are
 * permitted provided that the following conditions are met:
 *
 *   1. Redistributions of source code must retain the above copyright notice, this list of
 *      conditions and the following disclaimer.
 *
 *   2. Redistributions in binary form must reproduce the above copyright notice, this list
 *      of conditions and the following disclaimer in the documentation and/or other materials
 *      provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY MATTHIAS BUTZ ''AS IS'' AND ANY EXPRESS OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
 * FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL MATTHIAS BUTZ OR
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON
 * ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF
 * ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/

package cc.mtz.sts.zza.listener;

import cc.mtz.sts.zza.Main;
import cc.mtz.sts.zza.Rewriter;
import cc.mtz.sts.zza.data.RewrittenDetails;
import cc.mtz.sts.zza.data.DataCache;
import cc.mtz.sts.zza.data.Bahnhof;
import cc.mtz.sts.zza.ui.Zza;
import java.awt.DisplayMode;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import js.java.stspluginlib.PluginClient.ZugFahrplanZeile;

/**
 *
 * @author Matze
 */
public class ZzaManager implements StsListener {
    
    private int aNum = 0;
    private Bahnhof lastBhf;
    private final Map<String, Zza> windows = new HashMap();
        
    public void bahnsteigSetup(String bahnsteig, Bahnhof bahnhof) {
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice[] gs = ge.getScreenDevices();
        DisplayMode dm = gs[0].getDisplayMode();
        Zza zza = new Zza();
        //zza.setUndecorated(true);
        zza.setVisible(true);
        int windowsPerColumn = dm.getHeight() / zza.getHeight();
        if (bahnhof != lastBhf) {
            lastBhf = bahnhof;
            if (aNum > 0)
                aNum += (windowsPerColumn - (aNum % windowsPerColumn));
        }
        int column = aNum / windowsPerColumn;
        int row = aNum % windowsPerColumn;
        zza.setBounds(dm.getWidth() - (column + 1) * zza.getWidth(), row * zza.getHeight(), zza.getWidth(), zza.getHeight());
        aNum++;
        zza.setGleis(bahnsteig.replaceFirst("[^0-9]*(.*)$", "$1"));
        zza.setTitle(bahnsteig);
        zza.update("", "", "", "", "");
        windows.put(bahnsteig, zza);
    }

    public void naechsterZug(String gleis, Bahnhof bahnhof, int zid, DataCache cache) {
        RewrittenDetails details = Rewriter.getInstance().rewrite(cache.getDetailCache().get(zid));
        List<ZugFahrplanZeile> plan = cache.getFahrplaene().get(zid);
        if (Pattern.matches(Main.IGNORE_PATTERN, cache.getDetailCache().get(zid).name)) {
            windows.get(gleis).update("", "Achtung Zugdurchfahrt!", "", "", "");
        } else if (Pattern.matches(bahnhof.getEndeRegex(), cache.getDetailCache().get(zid).nach) 
                || Pattern.matches(bahnhof.getEndeRegex(), details.nach)) {
            StringBuilder infoString = new StringBuilder("+++ Bitte nicht einsteigen");
            if (details.verspaetung >= 1) {
                infoString.append(" +++ etwa ");
                infoString.append(details.verspaetung);
                infoString.append(" Minuten sp\u00e4ter");
            }
            infoString.append(" +++");
            int startIndex = 0;
            for (int i = 0; i < plan.size(); i++) {
                if (plan.get(i).gleis.equals(gleis)) {
                    startIndex = i + 1;
                    break;
                }
            }
            windows.get(gleis).update(details.name, "Von " + details.von, plan.get(startIndex - 1).getFormattedAn(), "Zug endet hier.", infoString.toString());
        } else {
            String vias = "";
            int startIndex = 0;
            for (int i = 0; i < plan.size(); i++) {
                if (plan.get(i).gleis.equals(gleis)) {
                    startIndex = i + 1;
                    break;
                }
            }
            if (details.rewritten) {
                vias = details.vias;
            } else {
                for (int i = startIndex; i < startIndex + 3; i++) {
                    String viaBhf = null;
                    if (viaBhf == null && plan.size() > i) {
                        vias += " - " + plan.get(i).gleis;
                    }
                    if (viaBhf != null && viaBhf.length() > 0) {
                        vias += " - " + viaBhf;
                    }
                }
                if (vias.length() > 0) {
                    vias = vias.substring(3);
                }
            }
            StringBuilder infoString = new StringBuilder("");
            if (details.verspaetung >= 1) {
                infoString.append("+++ etwa ");
                infoString.append(details.verspaetung);
                infoString.append(" Minuten sp\u00e4ter");
                infoString.append(" +++");
            }
            windows.get(gleis).update(details.name, details.nach, plan.get(startIndex - 1).getFormattedAb(), vias, infoString.toString());
        }
    }

    public void zugEinfahrt(String gleis, Bahnhof bahnhof, int zid, DataCache cache) {
        // ignore
    }

    public void idleAction(DataCache cache) {
        // ignore
    }
    
}
