/*
 * Copyright 2011 Matthias Butz <mtz@mtz.cc>. All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without modification, are
 * permitted provided that the following conditions are met:
 *
 *   1. Redistributions of source code must retain the above copyright notice, this list of
 *      conditions and the following disclaimer.
 *
 *   2. Redistributions in binary form must reproduce the above copyright notice, this list
 *      of conditions and the following disclaimer in the documentation and/or other materials
 *      provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY MATTHIAS BUTZ ''AS IS'' AND ANY EXPRESS OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
 * FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL MATTHIAS BUTZ OR
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON
 * ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF
 * ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/

package cc.mtz.sts.zza.data;

import java.util.Comparator;
import js.java.stspluginlib.PluginClient;
import js.java.stspluginlib.PluginClient.ZugDetails;
import js.java.stspluginlib.PluginClient.ZugFahrplanZeile;

/**
 *
 * @author Matze
 */
public class ZugBelegung {
    public PluginClient.ZugDetails zug;
    public PluginClient.ZugFahrplanZeile zeile;

    public ZugBelegung(ZugDetails zug, ZugFahrplanZeile zeile) {
        this.zug = zug;
        this.zeile = zeile;
    }
    
    public static class DelayComparator implements Comparator<ZugBelegung> {

        public int compare(ZugBelegung o1, ZugBelegung o2) {
            long o1time = o1.zeile.an;
            if (o1time == 0) {
                o1time = o1.zeile.ab;
                if (o1.zug != null) {
                    o1time += o1.zug.verspaetung * 60000;
                }
            }
            long o2time = o2.zeile.an;
            if (o2time == 0) {
                o2time = o2.zeile.ab;
                if (o2.zug != null) {
                    o2time += o2.zug.verspaetung * 60000;
                }
            }
            return (int) (o1time  - o2time);
        }
    }
    
}
