/*
 * Copyright 2011 Matthias Butz <mtz@mtz.cc>. All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without modification, are
 * permitted provided that the following conditions are met:
 *
 *   1. Redistributions of source code must retain the above copyright notice, this list of
 *      conditions and the following disclaimer.
 *
 *   2. Redistributions in binary form must reproduce the above copyright notice, this list
 *      of conditions and the following disclaimer in the documentation and/or other materials
 *      provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY MATTHIAS BUTZ ''AS IS'' AND ANY EXPRESS OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
 * FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL MATTHIAS BUTZ OR
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON
 * ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF
 * ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/

package cc.mtz.sts.zza.data;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import js.java.stspluginlib.PluginClient.ZugDetails;
import js.java.stspluginlib.PluginClient.ZugFahrplanZeile;

/**
 *
 * @author Matze
 */
public class DataCache {
    
    private Map<Integer, List<ZugFahrplanZeile>> fahrplaene = new HashMap();
    private Map<String, List<ZugBelegung>> belegung = new HashMap();
    private Map<Integer, ZugDetails> detailCache = new HashMap();
    
    public DataCache() {
        
    }
    
    public DataCache(DataCache toCopy) {
        fahrplaene = new HashMap(toCopy.fahrplaene);
        belegung = new HashMap(toCopy.belegung);
        detailCache = new HashMap(toCopy.detailCache);
    }
    
    public void clear() {
        fahrplaene.clear();
        belegung.clear();
        detailCache.clear();
    }

    public Map<String, List<ZugBelegung>> getBelegung() {
        return belegung;
    }

    public Map<Integer, ZugDetails> getDetailCache() {
        return detailCache;
    }

    public Map<Integer, List<ZugFahrplanZeile>> getFahrplaene() {
        return fahrplaene;
    }
    
    
    
}
