/*
 * Decompiled with CFR 0.152.
 */
package cc.mtz.sts.zza.listener;

import cc.mtz.sts.zza.Rewriter;
import cc.mtz.sts.zza.data.Bahnhof;
import cc.mtz.sts.zza.data.DataCache;
import cc.mtz.sts.zza.data.RewrittenDetails;
import cc.mtz.sts.zza.listener.StsListener;
import cc.mtz.sts.zza.ui.Zza;
import java.awt.DisplayMode;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import js.java.stspluginlib.PluginClient;

public class ZzaManager
implements StsListener {
    private int aNum = 0;
    private Bahnhof lastBhf;
    private final Map<String, Zza> windows = new HashMap<String, Zza>();

    public void bahnsteigSetup(String bahnsteig, Bahnhof bahnhof) {
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice[] gs = ge.getScreenDevices();
        DisplayMode dm = gs[0].getDisplayMode();
        Zza zza = new Zza();
        zza.setVisible(true);
        int windowsPerColumn = dm.getHeight() / zza.getHeight();
        if (bahnhof != this.lastBhf) {
            this.lastBhf = bahnhof;
            if (this.aNum > 0) {
                this.aNum += windowsPerColumn - this.aNum % windowsPerColumn;
            }
        }
        int column = this.aNum / windowsPerColumn;
        int row = this.aNum % windowsPerColumn;
        zza.setBounds(dm.getWidth() - (column + 1) * zza.getWidth(), row * zza.getHeight(), zza.getWidth(), zza.getHeight());
        ++this.aNum;
        zza.setGleis(bahnsteig.replaceFirst("[^0-9]*(.*)$", "$1"));
        zza.setTitle(bahnsteig);
        zza.update("", "", "", "", "");
        this.windows.put(bahnsteig, zza);
    }

    public void naechsterZug(String gleis, Bahnhof bahnhof, int zid, DataCache cache) {
        RewrittenDetails details = Rewriter.getInstance().rewrite(cache.getDetailCache().get(zid));
        List<PluginClient.ZugFahrplanZeile> plan = cache.getFahrplaene().get(zid);
        if (Pattern.matches("^(TEC|CS|RoLa|Lr|LR|IKL|CB|Tfzf|Ersatzlok|FE|CIL).*", cache.getDetailCache().get((Object)Integer.valueOf((int)zid)).name)) {
            this.windows.get(gleis).update("", "Achtung Zugdurchfahrt!", "", "", "");
        } else if (Pattern.matches(bahnhof.getEndeRegex(), cache.getDetailCache().get((Object)Integer.valueOf((int)zid)).nach) || Pattern.matches(bahnhof.getEndeRegex(), details.nach)) {
            StringBuilder infoString = new StringBuilder("+++ Bitte nicht einsteigen");
            if (details.verspaetung >= 1) {
                infoString.append(" +++ etwa ");
                infoString.append(details.verspaetung);
                infoString.append(" Minuten sp\u00e4ter");
            }
            infoString.append(" +++");
            int startIndex = 0;
            for (int i = 0; i < plan.size(); ++i) {
                if (!plan.get((int)i).gleis.equals(gleis)) continue;
                startIndex = i + 1;
                break;
            }
            this.windows.get(gleis).update(details.name, "Von " + details.von, plan.get(startIndex - 1).getFormattedAn(), "Zug endet hier.", infoString.toString());
        } else {
            int i;
            String vias = "";
            int startIndex = 0;
            for (i = 0; i < plan.size(); ++i) {
                if (!plan.get((int)i).gleis.equals(gleis)) continue;
                startIndex = i + 1;
                break;
            }
            if (details.rewritten) {
                vias = details.vias;
            } else {
                for (i = startIndex; i < startIndex + 3; ++i) {
                    String viaBhf = null;
                    if (viaBhf == null && plan.size() > i) {
                        vias = vias + " - " + plan.get((int)i).gleis;
                    }
                    if (viaBhf == null || viaBhf.length() <= 0) continue;
                    vias = vias + " - " + viaBhf;
                }
                if (vias.length() > 0) {
                    vias = vias.substring(3);
                }
            }
            StringBuilder infoString = new StringBuilder("");
            if (details.verspaetung >= 1) {
                infoString.append("+++ etwa ");
                infoString.append(details.verspaetung);
                infoString.append(" Minuten sp\u00e4ter");
                infoString.append(" +++");
            }
            this.windows.get(gleis).update(details.name, details.nach, plan.get(startIndex - 1).getFormattedAb(), vias, infoString.toString());
        }
    }

    public void zugEinfahrt(String gleis, Bahnhof bahnhof, int zid, DataCache cache) {
    }

    public void idleAction(DataCache cache) {
    }
}

