/*
 * Decompiled with CFR 0.152.
 */
package cc.mtz.sts.zza.listener;

import cc.mtz.sts.zza.AnsagenUtil;
import cc.mtz.sts.zza.AnschlussAnsage;
import cc.mtz.sts.zza.Main;
import cc.mtz.sts.zza.Rewriter;
import cc.mtz.sts.zza.StellwerkFile;
import cc.mtz.sts.zza.data.Bahnhof;
import cc.mtz.sts.zza.data.DataCache;
import cc.mtz.sts.zza.data.RewrittenDetails;
import cc.mtz.sts.zza.data.ZugBelegung;
import cc.mtz.sts.zza.listener.StsListener;
import cc.mtz.sts.zza.sound.SoundPlayer;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import js.java.stspluginlib.PluginClient;

public class AnsageManager
implements StsListener {
    private StellwerkFile config;
    private Map<String, Map<String, Long>> verspaetungsAnsageZeiten = new HashMap<String, Map<String, Long>>();
    private Map<String, Set<String>> einfahrtGemeldet = new HashMap<String, Set<String>>();
    private boolean einfahrten;
    private boolean anschluesse;
    private boolean verspaetungen;

    public AnsageManager(StellwerkFile config, boolean einfahrten, boolean anschluesse, boolean verspaetungen) {
        this.config = config;
        this.einfahrten = einfahrten;
        this.anschluesse = anschluesse;
        this.verspaetungen = verspaetungen;
    }

    public void bahnsteigSetup(String bahnsteig, Bahnhof bahnhof) {
    }

    public void naechsterZug(String gleis, Bahnhof bahnhof, int zid, DataCache cache) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void zugEinfahrt(String gleis, Bahnhof bahnhof, int zid, DataCache cache) {
        if (!this.einfahrtGemeldet.containsKey(gleis) || !this.einfahrtGemeldet.get(gleis).contains(cache.getDetailCache().get((Object)Integer.valueOf((int)zid)).name)) {
            if (!this.einfahrtGemeldet.containsKey(gleis)) {
                this.einfahrtGemeldet.put(gleis, new HashSet());
            }
            this.einfahrtGemeldet.get(gleis).add(cache.getDetailCache().get((Object)Integer.valueOf((int)zid)).name);
        }
        if (this.einfahrten) {
            RewrittenDetails details = Rewriter.getInstance().rewrite(cache.getDetailCache().get(zid));
            if (Pattern.matches("^(TEC|CS|RoLa|Lr|LR|IKL|CB|Tfzf|Ersatzlok|FE|CIL).*", details.name)) {
                return;
            }
            List<PluginClient.ZugFahrplanZeile> plan = cache.getFahrplaene().get(zid);
            if (Pattern.matches("^(TEC|CS|RoLa).*", cache.getDetailCache().get((Object)Integer.valueOf((int)zid)).name)) {
                SoundPlayer.getInstance().addText(SoundPlayer.Priority.HIGH, "Auf Gleis " + gleis.replaceFirst("[^0-9]*(.*)$", "$1") + " Vorsicht, ein Zug f\u00e4hrt durch. " + "Bitte zur\u00fcckbleiben.");
                SoundPlayer soundPlayer = SoundPlayer.getInstance();
                synchronized (soundPlayer) {
                    SoundPlayer.getInstance().notify();
                }
            }
            if (Pattern.matches(bahnhof.getEndeRegex(), cache.getDetailCache().get((Object)Integer.valueOf((int)zid)).nach) || Pattern.matches(bahnhof.getEndeRegex(), details.nach)) {
                int startIndex = 0;
                for (int i = 0; i < plan.size(); ++i) {
                    if (!plan.get((int)i).gleis.equals(gleis)) continue;
                    startIndex = i + 1;
                    break;
                }
                SoundPlayer.getInstance().addText(SoundPlayer.Priority.HIGH, "Auf Gleis " + gleis.replaceFirst("[^0-9]*(.*)$", "$1") + " Einfahrt: " + AnsagenUtil.ansagenName(details.name) + " von " + details.von + ". Ankunft " + plan.get(startIndex - 1).getFormattedAn() + " Uhr. Dieser Zug endet hier. Bitte nicht einsteigen. " + "Vorsicht bei der Einfahrt!");
                SoundPlayer i = SoundPlayer.getInstance();
                synchronized (i) {
                    SoundPlayer.getInstance().notify();
                }
                if (this.anschluesse) {
                    long anschlussZeit = (plan.get((int)(startIndex - 1)).an - Main.client.getSimutime()) / 1000L + (long)(details.verspaetung * 60);
                    if (anschlussZeit < 0L) {
                        anschlussZeit = 0L;
                    }
                    Main.ses.schedule(new AnschlussAnsage(gleis, bahnhof, zid), anschlussZeit, TimeUnit.SECONDS);
                }
            } else {
                int i;
                String vias = "";
                int startIndex = 0;
                for (i = 0; i < plan.size(); ++i) {
                    if (!plan.get((int)i).gleis.equals(gleis)) continue;
                    startIndex = i + 1;
                    break;
                }
                if (details.rewritten) {
                    vias = details.vias;
                } else {
                    for (i = startIndex; i < startIndex + 3; ++i) {
                        String viaBhf = null;
                        if (viaBhf == null && plan.size() > i) {
                            vias = vias + " - " + plan.get((int)i).gleis;
                        }
                        if (viaBhf == null || viaBhf.length() <= 0) continue;
                        vias = vias + " - " + viaBhf;
                    }
                    if (vias.length() > 0) {
                        vias = vias.substring(3);
                    }
                }
                String viaAnsage = "";
                if (vias.length() > 0) {
                    viaAnsage = " via " + vias;
                }
                StringBuilder ansagenText = new StringBuilder("Auf Gleis ");
                ansagenText.append(gleis.replaceFirst("[^0-9]*(.*)$", "$1"));
                if (Pattern.matches(bahnhof.getEndeRegex(), details.von)) {
                    ansagenText.append(" wird bereitgestellt: ");
                    ansagenText.append(AnsagenUtil.ansagenName(details.name));
                } else {
                    ansagenText.append(" Einfahrt: ");
                    ansagenText.append(AnsagenUtil.ansagenName(details.name));
                    ansagenText.append(" von ");
                    ansagenText.append(details.von);
                    ansagenText.append(" zur Weiterfahrt");
                    if (this.anschluesse) {
                        long anschlussZeit = (plan.get((int)(startIndex - 1)).an - Main.client.getSimutime()) / 1000L + (long)(details.verspaetung * 60);
                        if (anschlussZeit < 0L) {
                            anschlussZeit = 0L;
                        }
                        Main.ses.schedule(new AnschlussAnsage(gleis, bahnhof, zid), anschlussZeit, TimeUnit.SECONDS);
                    }
                }
                ansagenText.append(" nach ");
                ansagenText.append(details.nach);
                ansagenText.append(viaAnsage);
                ansagenText.append(". Abfahrt ");
                ansagenText.append(plan.get(startIndex - 1).getFormattedAb());
                ansagenText.append(" Uhr. Vorsicht bei der Einfahrt!");
                SoundPlayer.getInstance().addText(SoundPlayer.Priority.HIGH, ansagenText.toString());
                SoundPlayer soundPlayer = SoundPlayer.getInstance();
                synchronized (soundPlayer) {
                    SoundPlayer.getInstance().notify();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void idleAction(DataCache cache) {
        if (this.verspaetungen) {
            for (String gleis : cache.getBelegung().keySet()) {
                Bahnhof bahnhof = null;
                for (Bahnhof bhf : this.config.getBahnhoefe()) {
                    if (!Pattern.matches(bhf.getGleiseRegex(), gleis)) continue;
                    bahnhof = bhf;
                    break;
                }
                if (bahnhof == null) {
                    throw new RuntimeException("Bahnhof not found");
                }
                long simutime = Main.client.getSimutime();
                List<ZugBelegung> planBelegung = cache.getBelegung().get(gleis);
                if (planBelegung == null) continue;
                Collections.sort(planBelegung, new ZugBelegung.DelayComparator());
                for (ZugBelegung zugBelegung : planBelegung) {
                    if (zugBelegung.zeile == null || zugBelegung.zug == null || Pattern.matches("^(TEC|CS|RoLa|Lr|LR|IKL|CB|Tfzf|Ersatzlok|FE|CIL).*", zugBelegung.zug.name) || (zugBelegung.zeile.an + (long)(zugBelegung.zug.verspaetung * 60000) <= simutime || (zugBelegung.zeile.an - simutime) / 60000L > 15L) && (zugBelegung.zeile.ab + (long)(zugBelegung.zug.verspaetung * 60000) <= simutime || (zugBelegung.zeile.ab - simutime) / 60000L > 15L) || zugBelegung.zug.verspaetung < 5 || this.einfahrtGemeldet.containsKey(gleis) && this.einfahrtGemeldet.get(gleis).contains(zugBelegung.zug.name) || this.verspaetungsAnsageZeiten.containsKey(gleis) && this.verspaetungsAnsageZeiten.get(gleis).containsKey(zugBelegung.zug.name) && simutime - this.verspaetungsAnsageZeiten.get(gleis).get(zugBelegung.zug.name) < 300000L) continue;
                    RewrittenDetails details = Rewriter.getInstance().rewrite(zugBelegung.zug);
                    if (!this.verspaetungsAnsageZeiten.containsKey(gleis)) {
                        this.verspaetungsAnsageZeiten.put(gleis, new HashMap());
                    }
                    this.verspaetungsAnsageZeiten.get(gleis).put(details.name, simutime);
                    StringBuilder zugLauf = new StringBuilder();
                    String zeitText = "";
                    if (!Pattern.matches(bahnhof.getEndeRegex(), details.von) && !details.von.equals("")) {
                        zugLauf.append(" von ");
                        zugLauf.append(details.von);
                        zeitText = "Ankunftszeit " + zugBelegung.zeile.getFormattedAn() + " Uhr";
                    }
                    if (!Pattern.matches(bahnhof.getEndeRegex(), details.nach) && !details.nach.equals("")) {
                        zugLauf.append(" nach ");
                        zugLauf.append(details.nach);
                        zeitText = "Abfahrtzeit " + zugBelegung.zeile.getFormattedAb() + " Uhr";
                    }
                    SoundPlayer.getInstance().addText(SoundPlayer.Priority.LOW, "Auf Gleis " + gleis.replaceFirst("[^0-9]*(.*)$", "$1") + " Bitte beachten sie zu " + AnsagenUtil.ansagenName(details.name) + zugLauf.toString() + ", planm\u00e4\u00dfige " + zeitText + ": Dieser Zug wird heute voraussichtlich " + details.verspaetung + " Minuten sp\u00e4ter hier eintreffen. Wir bitten um Verst\u00e4ndnis.");
                    SoundPlayer soundPlayer = SoundPlayer.getInstance();
                    synchronized (soundPlayer) {
                        SoundPlayer.getInstance().notify();
                    }
                }
            }
        }
    }
}

