/*
 * Decompiled with CFR 0.152.
 */
package cc.mtz.sts.zza;

import cc.mtz.sts.zza.StellwerkFile;
import cc.mtz.sts.zza.data.Bahnhof;
import cc.mtz.sts.zza.data.RewrittenDetails;
import cc.mtz.sts.zza.data.ZugRewrite;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.text.DateFormatter;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import js.java.stspluginlib.PluginClient;
import org.ccil.cowan.tagsoup.Parser;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class Rewriter {
    private final boolean fallbackToRis;
    private static Rewriter instance;
    private StellwerkFile config;

    public static void init(StellwerkFile config, boolean fallbackToRis) {
        instance = new Rewriter(config, fallbackToRis);
    }

    public static Rewriter getInstance() {
        if (instance == null) {
            throw new IllegalStateException("Not initialized");
        }
        return instance;
    }

    private Rewriter(StellwerkFile config, boolean fallbackToRis) {
        this.config = config;
        this.fallbackToRis = fallbackToRis;
    }

    public RewrittenDetails rewrite(PluginClient.ZugDetails details) {
        RewrittenDetails ret = new RewrittenDetails(details);
        boolean rewritten = false;
        for (ZugRewrite rewrite : this.config.getRewrites()) {
            if (!rewrite.matches(details)) continue;
            rewritten = true;
            ret = rewrite.rewrite(details);
            if (rewrite.getVias() == null || rewrite.getVias().size() <= 0) break;
            StringBuilder viaString = new StringBuilder();
            for (String via : rewrite.getVias()) {
                viaString.append(" - ");
                viaString.append(via);
            }
            ret.vias = viaString.substring(3);
            break;
        }
        if (!rewritten && this.fallbackToRis) {
            try {
                RisParser parser = new RisParser();
                Rewriter.processRis(details.name, parser);
                if (parser.getStartBhf() != null && parser.getEndBhf() != null) {
                    ret.von = parser.getStartBhf();
                    ret.nach = parser.getEndBhf();
                    if (parser.getVias().size() > 1) {
                        int startIndex = 0;
                        for (int i = 0; i < parser.getVias().size() - 1; ++i) {
                            for (Bahnhof bahnhof : this.config.getBahnhoefe()) {
                                if (!parser.getVias().get(i).equals(bahnhof.getName())) continue;
                                startIndex = i + 1;
                            }
                        }
                        StringBuilder viaString = new StringBuilder();
                        int interval = (parser.getVias().size() - 1) / 4;
                        for (int i = startIndex; i < parser.getVias().size() - 1; i += interval) {
                            viaString.append(" - ");
                            viaString.append(parser.getVias().get(i));
                        }
                        if (viaString.length() > 3) {
                            ret.vias = viaString.substring(3);
                        }
                    }
                    rewritten = true;
                } else {
                    Logger.getLogger(Rewriter.class.getName()).log(Level.WARNING, "Error fetching from RIS - Parsing not successful");
                }
            }
            catch (MalformedURLException ex) {
                Logger.getLogger(Rewriter.class.getName()).log(Level.WARNING, "Error fetching from RIS", ex);
            }
            catch (SAXException ex) {
                Logger.getLogger(Rewriter.class.getName()).log(Level.WARNING, "Error fetching from RIS", ex);
            }
            catch (IOException ex) {
                Logger.getLogger(Rewriter.class.getName()).log(Level.WARNING, "Error fetching from RIS", ex);
            }
            catch (TransformerConfigurationException ex) {
                Logger.getLogger(Rewriter.class.getName()).log(Level.WARNING, "Error fetching from RIS", ex);
            }
            catch (TransformerException ex) {
                Logger.getLogger(Rewriter.class.getName()).log(Level.WARNING, "Error fetching from RIS", ex);
            }
            catch (ParserConfigurationException ex) {
                Logger.getLogger(Rewriter.class.getName()).log(Level.WARNING, "Error fetching from RIS", ex);
            }
            catch (ParseException ex) {
                Logger.getLogger(Rewriter.class.getName()).log(Level.WARNING, "Error fetching from RIS", ex);
            }
        }
        ret.rewritten = rewritten;
        return ret;
    }

    private static void processRis(String zug, RisParser risHandler) throws ParseException, MalformedURLException, SAXException, IOException, TransformerConfigurationException, TransformerException, ParserConfigurationException {
        int val;
        String productClass = zug.startsWith("ICE ") ? "1" : (zug.startsWith("IC ") || zug.startsWith("EC ") ? "2" : (zug.startsWith("IRE ") ? "8" : (zug.startsWith("IR ") || zug.startsWith("D ") ? "4" : "8")));
        DateFormatter df = new DateFormatter(new SimpleDateFormat("dd.MM.yy"));
        Calendar cal = Calendar.getInstance();
        cal.set(6, cal.get(6) + 1);
        URL url = new URL("http://mobile.bahn.de/bin/mobil/trainsearch.exe/dox?ld=96236&rt=1&use_realtime_filter=1&date=" + df.valueToString(cal.getTime()) + "&trainname=" + zug.replaceAll("[a-zA-Z ]", "") + "&stationFilter=80&start=Suchen&productClassFilter=" + productClass);
        URLConnection conn = url.openConnection();
        InputStream is = conn.getInputStream();
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        do {
            if ((val = is.read()) == -1) continue;
            bos.write(val);
        } while (val != -1);
        try {
            is.close();
        }
        catch (Exception ex) {
            // empty catch block
        }
        Parser parser = new Parser();
        parser.setFeature("http://www.ccil.org/~cowan/tagsoup/features/bogons-empty", false);
        parser.setFeature("http://xml.org/sax/features/namespaces", false);
        parser.setContentHandler(risHandler);
        parser.parse(new InputSource(new ByteArrayInputStream(bos.toByteArray())));
        parser = null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class RisParser
    extends DefaultHandler {
        private StringBuilder chars = new StringBuilder();
        private Mode mode = Mode.NONE;
        private String startBhf;
        private String endBhf;
        private List<String> vias = new LinkedList<String>();

        private RisParser() {
        }

        @Override
        public void characters(char[] ch, int start, int length) throws SAXException {
            this.chars.append(new String(ch, start, length));
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            if (qName.equals("td")) {
                switch (this.mode) {
                    case START_BHF: {
                        this.startBhf = this.chars.toString().trim();
                        break;
                    }
                    case END_BHF: {
                        this.endBhf = this.chars.toString().trim();
                        this.vias.add(this.chars.toString().trim());
                        break;
                    }
                }
            }
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            if (qName.equals("td")) {
                this.chars = new StringBuilder();
                this.mode = Mode.NONE;
                if (attributes.getValue(uri, "class") != null && attributes.getValue(uri, "class").equals("station tqdetail top")) {
                    this.mode = this.startBhf == null ? Mode.START_BHF : Mode.END_BHF;
                }
            }
        }

        public String getEndBhf() {
            return this.endBhf;
        }

        public String getStartBhf() {
            return this.startBhf;
        }

        public List<String> getVias() {
            return this.vias;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private static enum Mode {
            NONE,
            START_BHF,
            END_BHF;

        }
    }
}

