/*
 * Decompiled with CFR 0.152.
 */
package cc.mtz.sts.zza;

import cc.mtz.sts.zza.Main;
import cc.mtz.sts.zza.StellwerkFile;
import cc.mtz.sts.zza.data.Bahnhof;
import cc.mtz.sts.zza.data.DataCache;
import cc.mtz.sts.zza.data.ZugBelegung;
import cc.mtz.sts.zza.listener.StsListener;
import cc.mtz.sts.zza.sound.SoundPlayer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import js.java.stspluginlib.PluginClient;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PluginClientImpl
extends PluginClient {
    private final StellwerkFile config;
    private final List<StsListener> listener;
    private boolean ready = true;
    private DataCache currentCache;
    private DataCache lastRunCache;
    private Set<Integer> zuegeZuVerarbeiten;
    private Map<String, Set<String>> einfahrtGemeldet = new HashMap<String, Set<String>>();

    public PluginClientImpl(String name, String author, String version, String text, StellwerkFile config, List<StsListener> listener) {
        super(name, author, version, text);
        this.config = config;
        this.listener = listener;
        this.currentCache = new DataCache();
        SoundPlayer.getInstance().addReplaces(config.getSoundReplaces());
    }

    public DataCache getLastRunCache() {
        return new DataCache(this.lastRunCache);
    }

    @Override
    protected void connected() {
        this.request_bahnsteigliste();
    }

    @Override
    protected void closed() {
        System.exit(0);
    }

    @Override
    protected void response_anlageninfo(int aid, String name, String build) {
    }

    @Override
    protected void response_bahnsteigliste(HashMap<String, HashSet<String>> bl) {
        ArrayList<String> keys = new ArrayList<String>(bl.keySet());
        Collections.sort(keys);
        for (int bhf = 0; bhf < this.config.getBahnhoefe().size(); ++bhf) {
            for (String bahnsteig : keys) {
                if (!Pattern.matches(this.config.getBahnhoefe().get(bhf).getGleiseRegex(), bahnsteig)) continue;
                for (StsListener callback : this.listener) {
                    callback.bahnsteigSetup(bahnsteig, this.config.getBahnhoefe().get(bhf));
                }
            }
        }
        if (this.ready) {
            this.ready = false;
            this.currentCache.clear();
            this.request_zugliste();
        }
    }

    @Override
    protected void response_zugliste(HashMap<Integer, String> zl) {
        this.zuegeZuVerarbeiten = new HashSet<Integer>(zl.keySet());
        for (int zid : zl.keySet()) {
            this.request_zugdetails(zid);
        }
    }

    @Override
    protected void response_zugdetails(int zid, PluginClient.ZugDetails details) {
        this.currentCache.getDetailCache().put(zid, details);
        this.request_zugfahrplan(zid);
    }

    @Override
    protected void response_zugfahrplan(int zid, LinkedList<PluginClient.ZugFahrplanZeile> plan) {
        try {
            this.currentCache.getFahrplaene().put(zid, plan);
            this.zuegeZuVerarbeiten.remove(zid);
            for (PluginClient.ZugFahrplanZeile zeile : plan) {
                for (Bahnhof bahnhof : this.config.getBahnhoefe()) {
                    if (!Pattern.matches(bahnhof.getGleiseRegex(), zeile.gleis)) continue;
                    List<ZugBelegung> gleisBelegung = this.currentCache.getBelegung().get(zeile.gleis);
                    if (gleisBelegung == null) {
                        gleisBelegung = new ArrayList<ZugBelegung>();
                    }
                    gleisBelegung.add(new ZugBelegung(this.currentCache.getDetailCache().get(zid), zeile));
                    this.currentCache.getBelegung().put(zeile.gleis, gleisBelegung);
                }
            }
            if (this.zuegeZuVerarbeiten.isEmpty()) {
                this.lastRunCache = new DataCache(this.currentCache);
                boolean soundIdle = SoundPlayer.getInstance().isIdle();
                long simutime = this.getSimutime();
                block4: for (String gleis : this.currentCache.getBelegung().keySet()) {
                    List<ZugBelegung> gleisBelegung = this.currentCache.getBelegung().get(gleis);
                    if (gleisBelegung == null) continue;
                    Collections.sort(gleisBelegung, new ZugBelegung.DelayComparator());
                    for (ZugBelegung zugBelegung : gleisBelegung) {
                        if (zugBelegung.zeile == null || zugBelegung.zug == null || zugBelegung.zeile.an + (long)(zugBelegung.zug.verspaetung * 60000) <= simutime && zugBelegung.zeile.ab + (long)(zugBelegung.zug.verspaetung * 60000) <= simutime) continue;
                        this.naechsterZug(zugBelegung.zug.zid, zugBelegung.zeile.gleis);
                        continue block4;
                    }
                }
                if (soundIdle) {
                    for (StsListener callback : this.listener) {
                        callback.idleAction(this.currentCache);
                    }
                }
                this.ready = true;
            }
        }
        catch (Exception ex) {
            Logger.getLogger(Main.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public void naechsterZug(int zid, String gleis) {
        if (this.currentCache.getDetailCache().get(zid) == null) {
            return;
        }
        Bahnhof bahnhof = null;
        for (Bahnhof bhf : this.config.getBahnhoefe()) {
            if (!Pattern.matches(bhf.getGleiseRegex(), gleis)) continue;
            bahnhof = bhf;
            break;
        }
        if (bahnhof == null) {
            return;
        }
        for (StsListener callback : this.listener) {
            callback.naechsterZug(gleis, bahnhof, zid, this.currentCache);
        }
        if (this.currentCache.getDetailCache().get((Object)Integer.valueOf((int)zid)).sichtbar && this.currentCache.getDetailCache().get((Object)Integer.valueOf((int)zid)).gleis.equals(gleis) && (!this.einfahrtGemeldet.containsKey(gleis) || !this.einfahrtGemeldet.get(gleis).contains(this.currentCache.getDetailCache().get((Object)Integer.valueOf((int)zid)).name))) {
            for (StsListener callback : this.listener) {
                if (!this.einfahrtGemeldet.containsKey(gleis)) {
                    this.einfahrtGemeldet.put(gleis, new HashSet());
                }
                this.einfahrtGemeldet.get(gleis).add(this.currentCache.getDetailCache().get((Object)Integer.valueOf((int)zid)).name);
                callback.zugEinfahrt(gleis, bahnhof, zid, this.currentCache);
            }
        }
    }

    public void requestZuege() {
        this.ready = false;
        this.currentCache.clear();
        this.request_zugliste();
    }

    public boolean isReady() {
        return this.ready;
    }
}

