/*
 * Decompiled with CFR 0.152.
 */
package cc.mtz.sts.zza;

import cc.mtz.sts.zza.AnsagenUtil;
import cc.mtz.sts.zza.Main;
import cc.mtz.sts.zza.Rewriter;
import cc.mtz.sts.zza.data.Bahnhof;
import cc.mtz.sts.zza.data.DataCache;
import cc.mtz.sts.zza.data.RewrittenDetails;
import cc.mtz.sts.zza.data.ZugBelegung;
import cc.mtz.sts.zza.sound.SoundPlayer;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;

public class AnschlussAnsage
implements Runnable {
    private String gleis;
    private int zid;
    private Bahnhof bahnhof;

    public AnschlussAnsage(String gleis, Bahnhof bahnhof, int zid) {
        this.gleis = gleis;
        this.zid = zid;
        this.bahnhof = bahnhof;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        try {
            DataCache cache = Main.client.getLastRunCache();
            StringBuilder ansage = new StringBuilder("Auf Gleis ");
            ansage.append(this.gleis.replaceFirst("[^0-9]*(.*)$", "$1"));
            ansage.append(" Willkommen in ");
            ansage.append(this.bahnhof.getName());
            ansage.append(". Eingefahrener  ");
            String vias = "";
            RewrittenDetails details = Rewriter.getInstance().rewrite(cache.getDetailCache().get(this.zid));
            ansage.append(AnsagenUtil.ansagenName(details.name));
            if (details.nach == null || Pattern.matches(this.bahnhof.getEndeRegex(), details.nach)) {
                ansage.append(" endet hier");
            } else {
                ansage.append(" f\u00e4hrt weiter nach ");
                ansage.append(details.nach);
                if (!vias.isEmpty()) {
                    ansage.append(" via ");
                    ansage.append(vias);
                }
            }
            ansage.append(". Ihre n\u00e4chsten Anschl\u00fcsse: ");
            for (String nachbargleis : cache.getBelegung().keySet()) {
                if (!Pattern.matches(this.bahnhof.getGleiseRegex(), nachbargleis) || nachbargleis.equals(this.gleis)) continue;
                List<ZugBelegung> zuege = cache.getBelegung().get(nachbargleis);
                Collections.sort(zuege, new ZugBelegung.DelayComparator());
                for (ZugBelegung planzug : zuege) {
                    if (Pattern.matches("^(TEC|CS|RoLa|Lr|LR|IKL|CB|Tfzf|Ersatzlok|FE|CIL).*", planzug.zug.name) || planzug.zeile.ab <= 0L || planzug.zeile.ab > Main.client.getSimutime() + 900000L && planzug.zeile.ab + (long)(planzug.zug.verspaetung * 60000) > Main.client.getSimutime() + 900000L || Pattern.matches(this.bahnhof.getEndeRegex(), planzug.zug.nach)) continue;
                    details = Rewriter.getInstance().rewrite(cache.getDetailCache().get(planzug.zug.zid));
                    if (planzug.zug.verspaetung >= 5) {
                        ansage.append("Versp\u00e4teter ");
                    }
                    ansage.append(AnsagenUtil.ansagenName(planzug.zug.name));
                    ansage.append(" nach ");
                    ansage.append(details.nach);
                    ansage.append(" Abfahrt ");
                    if (planzug.zug.verspaetung >= 5) {
                        ansage.append("heute voraussichtlich ");
                        ansage.append((int)((planzug.zeile.ab + (long)(planzug.zug.verspaetung * 60000)) / 60000L) / 60);
                        ansage.append(":");
                        ansage.append((int)((planzug.zeile.ab + (long)(planzug.zug.verspaetung * 60000)) / 60000L) % 60);
                        ansage.append(" Uhr");
                    } else {
                        ansage.append(planzug.zeile.getFormattedAb());
                        ansage.append(" Uhr");
                    }
                    ansage.append(" von Gleis ");
                    ansage.append(nachbargleis.replaceFirst("[^0-9]*(.*)$", "$1"));
                    ansage.append(". ");
                }
            }
            SoundPlayer.getInstance().addText(SoundPlayer.Priority.MEDIUM, ansage.toString());
            SoundPlayer soundPlayer = SoundPlayer.getInstance();
            synchronized (soundPlayer) {
                SoundPlayer.getInstance().notify();
            }
        }
        catch (Exception ex) {
            Logger.getAnonymousLogger().log(Level.WARNING, "AnschlussAnsage", ex);
        }
    }
}

