/*
 * Decompiled with CFR 0.152.
 */
package js.java.tools.gui.dataTransferDisplay;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import javax.swing.JComponent;
import js.java.tools.gui.GraphicTools;

public class LedComponent
extends JComponent {
    private boolean mode = false;
    private LEDCOLOR cmode = LEDCOLOR.GREEN;

    public LedComponent() {
        Dimension dim = new Dimension(19, 19);
        this.setPreferredSize(dim);
        this.setMaximumSize(dim);
        this.setOpaque(false);
    }

    public LedComponent(LEDCOLOR col) {
        this();
        this.cmode = col;
    }

    public void setLed(boolean on) {
        this.mode = on;
        this.repaint();
    }

    @Override
    public void paintComponent(Graphics g) {
        Graphics2D g2 = (Graphics2D)g;
        GraphicTools.enableGfxAA((Graphics2D)g2);
        int b = 4;
        int x = 4;
        int y = 4;
        int w = this.getWidth() - 8;
        int h = this.getHeight() - 8;
        if (this.mode) {
            g2.setColor(this.cmode.colTrue());
        } else {
            g2.setColor(this.cmode.colFalse());
        }
        g2.fillOval(x, y, w, h);
        g2.setColor(Color.BLACK);
        g2.drawOval(x, y, w, h);
    }

    public static enum LEDCOLOR {
        GREEN(new Color(68, 255, 68), new Color(0, 119, 0)),
        YELLOW(new Color(255, 255, 68), new Color(119, 119, 0)),
        RED(new Color(204, 0, 0), new Color(102, 0, 0));

        private Color trueColor;
        private Color falseColor;

        private LEDCOLOR(Color trueColor, Color falseColor) {
            this.trueColor = trueColor;
            this.falseColor = falseColor;
        }

        private Color colTrue() {
            return this.trueColor;
        }

        private Color colFalse() {
            return this.falseColor;
        }
    }
}

